/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ShenyuWebHandler
implements WebHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebHandler.class);
    private final List<ShenyuPlugin> plugins;
    private final boolean scheduled;
    private Scheduler scheduler;

    public ShenyuWebHandler(List<ShenyuPlugin> plugins, ShenyuConfig shenyuConfig) {
        this.plugins = plugins;
        ShenyuConfig.Scheduler config = shenyuConfig.getScheduler();
        this.scheduled = config.getEnabled();
        if (this.scheduled) {
            this.scheduler = Objects.equals(config.getType(), "fixed") ? Schedulers.newParallel((String)"shenyu-work-threads", (int)config.getThreads()) : Schedulers.elastic();
        }
    }

    public Mono<Void> handle(@NonNull ServerWebExchange exchange) {
        Mono<Void> execute = new DefaultShenyuPluginChain(this.plugins).execute(exchange);
        if (this.scheduled) {
            return execute.subscribeOn(this.scheduler);
        }
        return execute;
    }

    public void putExtPlugins(List<ShenyuPlugin> extPlugins) {
        if (CollectionUtils.isEmpty(extPlugins)) {
            return;
        }
        List<ShenyuPlugin> shenyuPlugins = extPlugins.stream().filter(e -> this.plugins.stream().noneMatch(plugin -> plugin.named().equals(e.named()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(shenyuPlugins)) {
            shenyuPlugins.forEach(plugin -> {
                this.plugins.add((ShenyuPlugin)plugin);
                LOG.info("shenyu auto add extends plugins:{}", (Object)plugin.named());
            });
        }
    }

    private static class DefaultShenyuPluginChain
    implements ShenyuPluginChain {
        private int index;
        private final List<ShenyuPlugin> plugins;

        DefaultShenyuPluginChain(List<ShenyuPlugin> plugins) {
            this.plugins = plugins;
        }

        public Mono<Void> execute(ServerWebExchange exchange) {
            return Mono.defer(() -> {
                if (this.index < this.plugins.size()) {
                    ShenyuPlugin plugin;
                    boolean skip;
                    if (skip = (plugin = this.plugins.get(this.index++)).skip(exchange)) {
                        return this.execute(exchange);
                    }
                    return plugin.execute(exchange, (ShenyuPluginChain)this);
                }
                return Mono.empty();
            });
        }
    }
}

