/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.forward;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.plugin.api.RemoteAddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class ForwardedRemoteAddressResolver
implements RemoteAddressResolver {
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Logger LOG = LoggerFactory.getLogger(ForwardedRemoteAddressResolver.class);
    private final RemoteAddressResolver defaultRemoteIpResolver = new RemoteAddressResolver(){};
    private final int maxTrustedIndex;

    public ForwardedRemoteAddressResolver(int maxTrustedIndex) {
        this.maxTrustedIndex = maxTrustedIndex;
    }

    public static ForwardedRemoteAddressResolver trustAll() {
        return new ForwardedRemoteAddressResolver(Integer.MAX_VALUE);
    }

    public static ForwardedRemoteAddressResolver maxTrustedIndex(int maxTrustedIndex) {
        Assert.isTrue((maxTrustedIndex > 0 ? 1 : 0) != 0, (String)"An index greater than 0 is required");
        return new ForwardedRemoteAddressResolver(maxTrustedIndex);
    }

    public InetSocketAddress resolve(ServerWebExchange exchange) {
        List<String> xForwardedValues = this.extractXForwardedValues(exchange);
        Collections.reverse(xForwardedValues);
        if (!xForwardedValues.isEmpty()) {
            int index = Math.min(xForwardedValues.size(), this.maxTrustedIndex) - 1;
            return new InetSocketAddress(xForwardedValues.get(index), 0);
        }
        return this.defaultRemoteIpResolver.resolve(exchange);
    }

    private List<String> extractXForwardedValues(ServerWebExchange exchange) {
        List xForwardedValues = exchange.getRequest().getHeaders().get((Object)X_FORWARDED_FOR);
        if (xForwardedValues == null || xForwardedValues.isEmpty()) {
            return Collections.emptyList();
        }
        if (xForwardedValues.size() > 1) {
            LOG.warn("Multiple X-Forwarded-For headers found, discarding all");
            return Collections.emptyList();
        }
        List<String> values = Arrays.asList(((String)xForwardedValues.get(0)).split(", "));
        if (values.size() == 1 && !StringUtils.hasText((String)values.get(0))) {
            return Collections.emptyList();
        }
        return values;
    }
}

