/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import org.apache.shenyu.common.utils.PathMatchUtils;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LocalDispatcherFilter
implements WebFilter {
    private static final String DISPATCHER_PATH = "/shenyu/**";
    private final DispatcherHandler dispatcherHandler;

    public LocalDispatcherFilter(DispatcherHandler dispatcherHandler) {
        this.dispatcherHandler = dispatcherHandler;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getURI().getPath();
        if (PathMatchUtils.match((String)DISPATCHER_PATH, (String)path)) {
            return this.dispatcherHandler.handle(exchange);
        }
        return chain.filter(exchange);
    }
}

