/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.bootstrap.configuration;

import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import org.apache.shenyu.bootstrap.configuration.NettyTcpConfig;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.http.server.HttpServer;
import reactor.netty.resources.LoopResources;

@Configuration
public class ShenyuNettyWebServerFactory {
    @Bean
    public NettyReactiveWebServerFactory nettyReactiveWebServerFactory() {
        NettyReactiveWebServerFactory webServerFactory = new NettyReactiveWebServerFactory();
        NettyTcpConfig nettyTcpConfig = this.nettyTcpConfig();
        webServerFactory.addServerCustomizers(new NettyServerCustomizer[]{new EventLoopNettyCustomizer(nettyTcpConfig)});
        return webServerFactory;
    }

    @Bean
    public NettyTcpConfig nettyTcpConfig() {
        return new NettyTcpConfig();
    }

    private static class EventLoopNettyCustomizer
    implements NettyServerCustomizer {
        private final NettyTcpConfig nettyTcpConfig;

        EventLoopNettyCustomizer(NettyTcpConfig nettyTcpConfig) {
            this.nettyTcpConfig = nettyTcpConfig;
        }

        public HttpServer apply(HttpServer httpServer) {
            return httpServer.tcpConfiguration(tcpServer -> tcpServer.runOn(LoopResources.create((String)"shenyu-netty", (int)this.nettyTcpConfig.getSelectCount(), (int)this.nettyTcpConfig.getWorkerCount(), (boolean)true)).selectorOption(ChannelOption.SO_BACKLOG, (Object)this.nettyTcpConfig.getSoBacklog()).selectorOption(ChannelOption.SO_REUSEADDR, (Object)this.nettyTcpConfig.isSoReuseaddr()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyTcpConfig.getConnectTimeoutMillis()).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyTcpConfig.getWriteBufferLowWaterMark(), this.nettyTcpConfig.getWriteBufferHighWaterMark())).option(ChannelOption.SO_KEEPALIVE, (Object)this.nettyTcpConfig.isSoKeepalive()).option(ChannelOption.SO_REUSEADDR, (Object)this.nettyTcpConfig.isSoReuseaddr()).option(ChannelOption.SO_LINGER, (Object)this.nettyTcpConfig.getSoLinger()).option(ChannelOption.TCP_NODELAY, (Object)this.nettyTcpConfig.isTcpNodelay()));
        }
    }
}

