/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j.executor;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.resilience4j.Resilience4JPlugin;
import org.apache.shenyu.plugin.resilience4j.conf.Resilience4JConf;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface Executor {
    public <T> Mono<T> run(Mono<T> var1, Function<Throwable, Mono<T>> var2, Resilience4JConf var3);

    default public Mono<Void> fallback(ServerWebExchange exchange, String uri, Throwable t) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return this.withoutFallback(exchange, t);
        }
        DispatcherHandler dispatcherHandler = (DispatcherHandler)SpringBeanUtils.getInstance().getBean(DispatcherHandler.class);
        ServerHttpRequest request = exchange.getRequest().mutate().uri(Objects.requireNonNull(UriUtils.createUri((String)uri))).build();
        ServerWebExchange mutated = exchange.mutate().request(request).build();
        return dispatcherHandler.handle(mutated);
    }

    default public Mono<Void> withoutFallback(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof TimeoutException) {
            exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_TIMEOUT.getCode(), (String)ShenyuResultEnum.SERVICE_TIMEOUT.getMsg(), null);
        } else {
            if (throwable instanceof Resilience4JPlugin.CircuitBreakerStatusCodeException) {
                return Mono.error((Throwable)throwable);
            }
            if (throwable instanceof CallNotPermittedException) {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
            } else if (throwable instanceof RequestNotPermitted) {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                error = ShenyuResultWrap.error((int)ShenyuResultEnum.TOO_MANY_REQUESTS.getCode(), (String)ShenyuResultEnum.TOO_MANY_REQUESTS.getMsg(), null);
            } else {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
            }
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    default public Mono<Void> error(ServerWebExchange exchange) {
        exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

