/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j.executor;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterOperator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.shenyu.plugin.resilience4j.conf.Resilience4JConf;
import org.apache.shenyu.plugin.resilience4j.executor.Executor;
import org.apache.shenyu.plugin.resilience4j.factory.Resilience4JRegistryFactory;
import reactor.core.publisher.Mono;

public class CombinedExecutor
implements Executor {
    @Override
    public <T> Mono<T> run(Mono<T> run, Function<Throwable, Mono<T>> fallback, Resilience4JConf resilience4JConf) {
        RateLimiter rateLimiter = Resilience4JRegistryFactory.rateLimiter(resilience4JConf.getId(), resilience4JConf.getRateLimiterConfig());
        CircuitBreaker circuitBreaker = Resilience4JRegistryFactory.circuitBreaker(resilience4JConf.getId(), resilience4JConf.getCircuitBreakerConfig());
        Mono to = run.transformDeferred((Function)CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker)).transformDeferred((Function)RateLimiterOperator.of((RateLimiter)rateLimiter)).timeout(resilience4JConf.getTimeLimiterConfig().getTimeoutDuration()).doOnError(TimeoutException.class, t -> circuitBreaker.onError(resilience4JConf.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        if (fallback != null) {
            to = to.onErrorResume(fallback);
        }
        return to;
    }
}

