/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.client;

import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import org.apache.shenyu.plugin.grpc.client.ShenyuGrpcClient;
import org.apache.shenyu.plugin.grpc.loadbalance.LoadBalancerStrategy;
import org.apache.shenyu.plugin.grpc.loadbalance.RandomLoadBalancerProvider;
import org.apache.shenyu.plugin.grpc.loadbalance.RoundRobinLoadBalancerProvider;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuNameResolverProvider;

public class GrpcClientBuilder {
    public static ShenyuGrpcClient buildClient(String contextPath) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)contextPath).defaultLoadBalancingPolicy(LoadBalancerStrategy.RANDOM.getStrategy()).usePlaintext().maxInboundMessageSize(0x6400000).disableRetry();
        ManagedChannel channel = builder.build();
        channel.getState(true);
        return new ShenyuGrpcClient(channel);
    }

    static {
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RandomLoadBalancerProvider());
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RoundRobinLoadBalancerProvider());
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)new ShenyuNameResolverProvider());
    }
}

