/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.grpc.client.GrpcClientBuilder;
import org.apache.shenyu.plugin.grpc.client.ShenyuGrpcClient;

public class GrpcClientCache {
    private static final Map<String, ShenyuGrpcClient> CLIENT_CACHE = Maps.newConcurrentMap();

    public static void initGrpcClient(String contextPath) {
        CLIENT_CACHE.computeIfAbsent(contextPath, s -> GrpcClientBuilder.buildClient(contextPath));
    }

    public static ShenyuGrpcClient getGrpcClient(String contextPath) {
        return CLIENT_CACHE.get(contextPath);
    }

    public static void removeClient(String contextPath) {
        ShenyuGrpcClient grpcClient = CLIENT_CACHE.remove(contextPath);
        if (Objects.nonNull(grpcClient)) {
            grpcClient.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Map.Entry<String, ShenyuGrpcClient> entry : CLIENT_CACHE.entrySet()) {
                ShenyuGrpcClient grpcClient = entry.getValue();
                grpcClient.close();
            }
            CLIENT_CACHE.clear();
        }));
    }
}

