/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo.proxy;

import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.service.GenericService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.plugin.alibaba.dubbo.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.dubbo.common.param.DubboParamResolveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaDubboProxyService {
    private static final Logger LOG = LoggerFactory.getLogger(AlibabaDubboProxyService.class);
    private final DubboParamResolveService dubboParamResolveService;

    public AlibabaDubboProxyService(DubboParamResolveService dubboParamResolveService) {
        this.dubboParamResolveService = dubboParamResolveService;
    }

    public ResponseFuture genericInvoker(String body, MetaData metaData) throws ShenyuException {
        Object reference = ApplicationConfigCache.getInstance().get(metaData.getPath());
        if (Objects.isNull(reference) || StringUtils.isEmpty((CharSequence)reference.getInterface())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            reference = ApplicationConfigCache.getInstance().initRef(metaData);
        }
        try {
            GenericService genericService = (GenericService)reference.get();
            Object pair = StringUtils.isBlank((CharSequence)metaData.getParameterTypes()) || ParamCheckUtils.dubboBodyIsEmpty((String)body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : this.dubboParamResolveService.buildParameter(body, metaData.getParameterTypes());
            genericService.$invoke(metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight());
        }
        catch (GenericException e) {
            LOG.error("dubbo invoker have exception", (Throwable)e);
            throw new ShenyuException(e.getExceptionMessage());
        }
        FutureAdapter adapter = (FutureAdapter)RpcContext.getContext().getFuture();
        return adapter.getFuture();
    }
}

