/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo.cache;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private final int maxCount = 1000;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (config != null) {
            try {
                Class<?> cz = config.getClass();
                Field field = cz.getDeclaredField("ref");
                field.setAccessible(true);
                field.set(config, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.error("modify ref have exception", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        public ReferenceConfig<GenericService> load(String key) {
            return new ReferenceConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig("shenyu_proxy");
        }
        if (this.needUpdateRegistryConfig(dubboRegisterConfig)) {
            RegistryConfig registryConfigTemp = new RegistryConfig();
            registryConfigTemp.setProtocol(dubboRegisterConfig.getProtocol());
            registryConfigTemp.setId("shenyu_proxy");
            registryConfigTemp.setRegister(Boolean.valueOf(false));
            registryConfigTemp.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
            this.registryConfig = registryConfigTemp;
        }
    }

    private boolean needUpdateRegistryConfig(DubboRegisterConfig dubboRegisterConfig) {
        if (this.registryConfig == null) {
            return true;
        }
        return !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol()) || !Objects.equals(dubboRegisterConfig.getRegister(), this.registryConfig.getAddress()) || !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol());
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ReferenceConfig();
        }
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setAsync(Boolean.valueOf(true));
        reference.setLoadbalance("gray");
        String rpcExt = metaData.getRpcExt();
        DubboParamExtInfo dubboParamExtInfo = (DubboParamExtInfo)GsonUtils.getInstance().fromJson(rpcExt, DubboParamExtInfo.class);
        if (Objects.nonNull(dubboParamExtInfo)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getVersion()})) {
                reference.setVersion(dubboParamExtInfo.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getGroup()})) {
                reference.setGroup(dubboParamExtInfo.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getUrl()})) {
                reference.setUrl(dubboParamExtInfo.getUrl());
            }
            Optional.ofNullable(dubboParamExtInfo.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParamExtInfo.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
        }
        try {
            Object obj = reference.get();
            if (obj != null) {
                LOG.info("init alibaba dubbo reference success there meteData is :{}", (Object)metaData);
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            LOG.error("init alibaba dubbo refernce exception", (Throwable)e);
        }
        return reference;
    }

    public <T> ReferenceConfig<T> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static class DubboParamExtInfo {
        private String group;
        private String version;
        private String loadbalance;
        private Integer retries;
        private Integer timeout;
        private String url;

        DubboParamExtInfo() {
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getLoadbalance() {
            return this.loadbalance;
        }

        public void setLoadbalance(String loadbalance) {
            this.loadbalance = loadbalance;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    static class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        ApplicationConfigCacheInstance() {
        }
    }
}

