/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.alibaba.dubbo;

import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.plugin.alibaba.dubbo.proxy.AlibabaDubboProxyService;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.dubbo.common.AbstractDubboPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class AlibabaDubboPlugin
extends AbstractDubboPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AlibabaDubboPlugin.class);
    private final AlibabaDubboProxyService alibabaDubboProxyService;

    public AlibabaDubboPlugin(AlibabaDubboProxyService alibabaDubboProxyService) {
        this.alibabaDubboProxyService = alibabaDubboProxyService;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String param = (String)exchange.getAttribute("param_transform");
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        if (!this.checkMetaData(metaData)) {
            assert (metaData != null);
            LOG.error(" path is :{}, meta data have error.... {}", (Object)shenyuContext.getPath(), (Object)metaData);
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.META_DATA_ERROR.getCode(), (String)ShenyuResultEnum.META_DATA_ERROR.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaData.getParameterTypes()}) && StringUtils.isBlank((CharSequence)param)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.DUBBO_HAVE_BODY_PARAM.getCode(), (String)ShenyuResultEnum.DUBBO_HAVE_BODY_PARAM.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        RpcContext.getContext().setAttachment("dubboSelectorId", selector.getId());
        RpcContext.getContext().setAttachment("dubboRuleId", rule.getId());
        RpcContext.getContext().setAttachment("dubboRemoteAddress", Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress());
        return Mono.create(monoSink -> {
            ResponseFuture future = this.alibabaDubboProxyService.genericInvoker(param, metaData);
            future.setCallback(new ResponseCallback((MonoSink)monoSink, metaData, param){
                final /* synthetic */ MonoSink val$monoSink;
                final /* synthetic */ MetaData val$metaData;
                final /* synthetic */ String val$param;
                {
                    this.val$monoSink = monoSink;
                    this.val$metaData = metaData;
                    this.val$param = string;
                }

                public void done(Object resultObj) {
                    assert (resultObj instanceof Result);
                    Result result = (Result)resultObj;
                    if (result.hasException()) {
                        this.caught(result.getException());
                        return;
                    }
                    this.val$monoSink.success(result.getValue());
                }

                public void caught(Throwable ex) {
                    LOG.error("dubbo failed using async genericInvoker() metaData={} param={}", new Object[]{this.val$metaData, this.val$param, ex});
                    this.val$monoSink.error(ex);
                }
            });
        }).flatMap(response -> {
            exchange.getAttributes().put("rpc_result", Objects.nonNull(response) ? response : "dubbo has not return value!");
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return chain.execute(exchange);
        });
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    private boolean checkMetaData(MetaData metaData) {
        return null != metaData && !StringUtils.isBlank((CharSequence)metaData.getMethodName()) && !StringUtils.isBlank((CharSequence)metaData.getServiceName());
    }
}

