/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.modify.response;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ModifyResponseRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.modify.response.handler.ModifyResponsePluginDataHandler;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ModifyResponsePlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        ModifyResponseRuleHandle modifyResponseRuleHandle = (ModifyResponseRuleHandle)ModifyResponsePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.nonNull(modifyResponseRuleHandle)) {
            ClientResponse response = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.addAll((MultiValueMap)Objects.requireNonNull(response).headers().asHttpHeaders());
            if (MapUtils.isNotEmpty((Map)modifyResponseRuleHandle.getAddHeaders())) {
                Map addHeaderMap = modifyResponseRuleHandle.getAddHeaders();
                addHeaderMap.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            if (MapUtils.isNotEmpty((Map)modifyResponseRuleHandle.getSetHeaders())) {
                Map setHeaderMap = modifyResponseRuleHandle.getSetHeaders();
                setHeaderMap.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1));
            }
            if (MapUtils.isNotEmpty((Map)modifyResponseRuleHandle.getReplaceHeaderKeys())) {
                Map replaceHeaderMap = modifyResponseRuleHandle.getReplaceHeaderKeys();
                replaceHeaderMap.forEach((key, value) -> {
                    List cfr_ignored_0 = (List)httpHeaders.replace(key, Collections.singletonList(value));
                });
            }
            if (Objects.nonNull(modifyResponseRuleHandle.getRemoveHeaderKeys()) && !CollectionUtils.isEmpty((Collection)modifyResponseRuleHandle.getRemoveHeaderKeys())) {
                Set removeHeaderList = modifyResponseRuleHandle.getRemoveHeaderKeys();
                removeHeaderList.forEach(arg_0 -> ((HttpHeaders)httpHeaders).remove(arg_0));
            }
            if (modifyResponseRuleHandle.getStatusCode() > 0) {
                exchange.getResponse().setStatusCode(HttpStatus.valueOf((int)modifyResponseRuleHandle.getStatusCode()));
            }
            ClientResponse.Builder builder = ClientResponse.create((HttpStatus)Objects.requireNonNull(exchange.getResponse().getStatusCode()), (List)ServerCodecConfigurer.create().getReaders());
            Flux body = (Flux)response.body(BodyExtractors.toDataBuffers());
            ClientResponse modifyResponse = builder.headers(headers -> headers.putAll((Map)httpHeaders)).body(body).cookies(cookies -> cookies.putAll((Map)response.cookies())).build();
            exchange.getAttributes().put("webHandlerClientResponse", modifyResponse);
        }
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new ModifyServerHttpResponse(exchange, modifyResponseRuleHandle)).build());
    }

    public int getOrder() {
        return PluginEnum.MODIFY_RESPONSE.getCode();
    }

    public String named() {
        return PluginEnum.MODIFY_RESPONSE.getName();
    }

    static class ModifyServerHttpResponse
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final ModifyResponseRuleHandle handle;

        ModifyServerHttpResponse(ServerWebExchange exchange, ModifyResponseRuleHandle handle) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.handle = handle;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            ClientResponse clientResponse = (ClientResponse)this.exchange.getAttribute("webHandlerClientResponse");
            if (Objects.isNull(clientResponse)) {
                clientResponse = this.prepareClientResponse(body, this.getHeaders());
            }
            Mono modifiedBody = clientResponse.bodyToMono(byte[].class).flatMap(originalBody -> Mono.just((Object)this.updateResponse((byte[])originalBody)));
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, byte[].class);
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(this.exchange, this.exchange.getResponse().getHeaders());
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                Mono messageBody = DataBufferUtils.join((Publisher)outputMessage.getBody());
                HttpHeaders headers = this.getDelegate().getHeaders();
                if (!headers.containsKey((Object)"Transfer-Encoding") || headers.containsKey((Object)"Content-Length")) {
                    messageBody = messageBody.doOnNext(data -> headers.setContentLength((long)data.readableByteCount()));
                }
                return this.getDelegate().writeWith((Publisher)messageBody);
            }));
        }

        private byte[] updateResponse(byte[] responseBody) {
            if (Objects.isNull(this.handle)) {
                return responseBody;
            }
            String bodyStr = this.operation(new String(responseBody, StandardCharsets.UTF_8), this.handle);
            return bodyStr.getBytes(StandardCharsets.UTF_8);
        }

        private String operation(String jsonValue, ModifyResponseRuleHandle handle) {
            DocumentContext context = JsonPath.parse((String)jsonValue);
            if (!CollectionUtils.isEmpty((Collection)handle.getAddBodyKeys())) {
                handle.getAddBodyKeys().forEach(info -> context.put(info.getPath(), info.getKey(), (Object)info.getValue(), new Predicate[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)handle.getReplaceBodyKeys())) {
                handle.getReplaceBodyKeys().forEach(info -> context.renameKey(info.getPath(), info.getKey(), info.getValue(), new Predicate[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)handle.getRemoveBodyKeys())) {
                handle.getRemoveBodyKeys().forEach(x$0 -> context.delete(x$0, new Predicate[0]));
            }
            return context.jsonString();
        }

        private ClientResponse prepareClientResponse(Publisher<? extends DataBuffer> body, HttpHeaders httpHeaders) {
            ClientResponse.Builder builder = ClientResponse.create((HttpStatus)this.getDelegate().getStatusCode(), (List)ServerCodecConfigurer.create().getReaders());
            return builder.headers(headers -> headers.putAll((Map)httpHeaders)).body(Flux.from(body)).build();
        }
    }
}

