/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.sync.data.consul;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.consul.ConsulSyncDataService;
import org.apache.shenyu.sync.data.consul.config.ConsulConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ConsulSyncDataConfiguration.class})
@ConditionalOnProperty(prefix="shenyu.sync.consul", name={"url"})
public class ConsulSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulSyncDataConfiguration.class);

    @Bean
    public SyncDataService syncDataService(ObjectProvider<ConsulClient> consulClient, ObjectProvider<ConsulConfig> consulConfig, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers) {
        LOGGER.info("you use consul sync shenyu data.......");
        return new ConsulSyncDataService((ConsulClient)consulClient.getIfAvailable(), (ConsulConfig)consulConfig.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.consul")
    public ConsulConfig consulConfig() {
        return new ConsulConfig();
    }

    @Bean
    public ConsulClient consulClient(ConsulConfig consulConfig) {
        return new ConsulClient(consulConfig.getUrl());
    }
}

