/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.command;

import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import java.net.URI;
import java.util.Objects;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;

public interface Command {
    public Observable<Void> fetchObservable();

    public boolean isCircuitBreakerOpen();

    default public Object generateError(ServerWebExchange exchange, Throwable exception) {
        Object error;
        if (exception instanceof HystrixRuntimeException) {
            HystrixRuntimeException e = (HystrixRuntimeException)exception;
            if (e.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
                error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_TIMEOUT.getCode(), (String)ShenyuResultEnum.SERVICE_TIMEOUT.getMsg(), null);
            } else {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
            }
        } else if (exception instanceof HystrixTimeoutException) {
            exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_TIMEOUT.getCode(), (String)ShenyuResultEnum.SERVICE_TIMEOUT.getMsg(), null);
        } else {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        }
        return error;
    }

    default public Mono<Void> doFallback(ServerWebExchange exchange, Throwable exception) {
        if (Objects.isNull(this.getCallBackUri())) {
            Object error = this.generateError(exchange, exception);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        DispatcherHandler dispatcherHandler = (DispatcherHandler)SpringBeanUtils.getInstance().getBean(DispatcherHandler.class);
        ServerHttpRequest request = exchange.getRequest().mutate().uri(this.getCallBackUri()).build();
        ServerWebExchange mutated = exchange.mutate().request(request).build();
        return dispatcherHandler.handle(mutated);
    }

    public URI getCallBackUri();
}

