/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleDataRefresh
extends AbstractDataRefresh<RuleData> {
    private static final Logger LOG = LoggerFactory.getLogger(RuleDataRefresh.class);
    private final PluginDataSubscriber pluginDataSubscriber;

    public RuleDataRefresh(PluginDataSubscriber pluginDataSubscriber) {
        this.pluginDataSubscriber = pluginDataSubscriber;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.RULE.name());
    }

    @Override
    protected ConfigData<RuleData> fromJson(JsonObject data) {
        return (ConfigData)GSON.fromJson((JsonElement)data, new TypeToken<ConfigData<RuleData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<RuleData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.RULE);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.RULE);
    }

    @Override
    protected void refresh(List<RuleData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all rule cache, old cache");
            data.forEach(arg_0 -> ((PluginDataSubscriber)this.pluginDataSubscriber).unRuleSubscribe(arg_0));
            this.pluginDataSubscriber.refreshRuleDataAll();
        } else {
            this.pluginDataSubscriber.refreshRuleDataAll();
            data.forEach(arg_0 -> ((PluginDataSubscriber)this.pluginDataSubscriber).onRuleSubscribe(arg_0));
        }
    }
}

