/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.constant.HttpConstants;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ThreadUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.apache.shenyu.sync.data.http.refresh.DataRefreshFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpSyncDataService
implements SyncDataService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSyncDataService.class);
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private static final Gson GSON = new Gson();
    private Duration connectionTimeout = Duration.ofSeconds(10L);
    private RestTemplate httpClient;
    private ExecutorService executor;
    private HttpConfig httpConfig;
    private List<String> serverList;
    private DataRefreshFactory factory;

    public HttpSyncDataService(HttpConfig httpConfig, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.factory = new DataRefreshFactory(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers);
        this.httpConfig = httpConfig;
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)httpConfig.getUrl()));
        this.httpClient = this.createRestTemplate();
        this.start();
    }

    private RestTemplate createRestTemplate() {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setConnectTimeout((int)this.connectionTimeout.toMillis());
        factory.setReadTimeout((int)HttpConstants.CLIENT_POLLING_READ_TIMEOUT);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    private void start() {
        if (RUNNING.compareAndSet(false, true)) {
            this.fetchGroupConfig(ConfigGroupEnum.values());
            int threadSize = this.serverList.size();
            this.executor = new ThreadPoolExecutor(threadSize, threadSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ShenyuThreadFactory.create((String)"http-long-polling", (boolean)true));
            this.serverList.forEach(server -> this.executor.execute(new HttpLongPollingTask((String)server)));
        } else {
            LOG.info("shenyu http long polling was started, executor=[{}]", (Object)this.executor);
        }
    }

    private void fetchGroupConfig(ConfigGroupEnum ... groups) throws ShenyuException {
        for (int index = 0; index < this.serverList.size(); ++index) {
            String server = this.serverList.get(index);
            try {
                this.doFetchGroupConfig(server, groups);
                break;
            }
            catch (ShenyuException e) {
                if (index >= this.serverList.size() - 1) {
                    throw e;
                }
                LOG.warn("fetch config fail, try another one: {}", (Object)this.serverList.get(index + 1));
                continue;
            }
        }
    }

    private void doFetchGroupConfig(String server, ConfigGroupEnum ... groups) {
        StringBuilder params = new StringBuilder();
        for (ConfigGroupEnum groupKey : groups) {
            params.append("groupKeys").append("=").append(groupKey.name()).append("&");
        }
        String url = server + "/configs/fetch?" + StringUtils.removeEnd((String)params.toString(), (String)"&");
        LOG.info("request configs: [{}]", (Object)url);
        String json = null;
        try {
            json = (String)this.httpClient.getForObject(url, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            String message = String.format("fetch config fail from server[%s], %s", url, e.getMessage());
            LOG.warn(message);
            throw new ShenyuException(message, (Throwable)e);
        }
        boolean updated = this.updateCacheWithJson(json);
        if (updated) {
            LOG.info("get latest configs: [{}]", (Object)json);
            return;
        }
        LOG.info("The config of the server[{}] has not been updated or is out of date. Wait for 30s to listen for changes again.", (Object)server);
        ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)30);
    }

    private boolean updateCacheWithJson(String json) {
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        JsonObject data = jsonObject.getAsJsonObject("data");
        return this.factory.executor(data);
    }

    private void doLongPolling(String server) {
        Object[] changedGroups;
        LinkedMultiValueMap params = new LinkedMultiValueMap(8);
        for (ConfigGroupEnum group : ConfigGroupEnum.values()) {
            ConfigData<?> cacheConfig = this.factory.cacheConfigData(group);
            if (cacheConfig == null) continue;
            String value = String.join((CharSequence)",", cacheConfig.getMd5(), String.valueOf(cacheConfig.getLastModifyTime()));
            params.put((Object)group.name(), (Object)Lists.newArrayList((Object[])new String[]{value}));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String listenerUrl = server + "/configs/listener";
        LOG.debug("request listener configs: [{}]", (Object)listenerUrl);
        JsonArray groupJson = null;
        try {
            String json = (String)this.httpClient.postForEntity(listenerUrl, (Object)httpEntity, String.class, new Object[0]).getBody();
            LOG.debug("listener result: [{}]", (Object)json);
            groupJson = ((JsonObject)GSON.fromJson(json, JsonObject.class)).getAsJsonArray("data");
        }
        catch (RestClientException e) {
            String message = String.format("listener configs fail, server:[%s], %s", server, e.getMessage());
            throw new ShenyuException(message, (Throwable)e);
        }
        if (groupJson != null && ArrayUtils.isNotEmpty((Object[])(changedGroups = (ConfigGroupEnum[])GSON.fromJson((JsonElement)groupJson, ConfigGroupEnum[].class)))) {
            LOG.info("Group config changed: {}", (Object)Arrays.toString(changedGroups));
            this.doFetchGroupConfig(server, (ConfigGroupEnum[])changedGroups);
        }
    }

    @Override
    public void close() throws Exception {
        RUNNING.set(false);
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    class HttpLongPollingTask
    implements Runnable {
        private String server;
        private final int retryTimes = 3;

        HttpLongPollingTask(String server) {
            this.server = server;
        }

        @Override
        public void run() {
            while (RUNNING.get()) {
                for (int time = 1; time <= 3; ++time) {
                    try {
                        HttpSyncDataService.this.doLongPolling(this.server);
                        continue;
                    }
                    catch (Exception e) {
                        if (time < 3) {
                            LOG.warn("Long polling failed, tried {} times, {} times left, will be suspended for a while! {}", new Object[]{time, 3 - time, e.getMessage()});
                            ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)5);
                            continue;
                        }
                        LOG.error("Long polling failed, try again after 5 minutes!", (Throwable)e);
                        ThreadUtils.sleep((TimeUnit)TimeUnit.MINUTES, (int)5);
                    }
                }
            }
            LOG.warn("Stop http long polling.");
        }
    }
}

