/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket.handler;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.plugin.sync.data.websocket.handler.DataHandler;

public abstract class AbstractDataHandler<T>
implements DataHandler {
    protected abstract List<T> convert(String var1);

    protected abstract void doRefresh(List<T> var1);

    protected abstract void doUpdate(List<T> var1);

    protected abstract void doDelete(List<T> var1);

    @Override
    public void handle(String json, String eventType) {
        List<T> dataList = this.convert(json);
        if (CollectionUtils.isNotEmpty(dataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    this.doRefresh(dataList);
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    this.doUpdate(dataList);
                    break;
                }
                case DELETE: {
                    this.doDelete(dataList);
                    break;
                }
            }
        }
    }
}

