/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.plugin.sync.data.websocket.client.ShenyuWebsocketClient;
import org.apache.shenyu.plugin.sync.data.websocket.config.WebsocketConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketSyncDataService
implements SyncDataService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketSyncDataService.class);
    private final List<WebSocketClient> clients = new ArrayList<WebSocketClient>();
    private final ScheduledThreadPoolExecutor executor;

    public WebsocketSyncDataService(WebsocketConfig websocketConfig, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        String[] urls = StringUtils.split((String)websocketConfig.getUrls(), (String)",");
        this.executor = new ScheduledThreadPoolExecutor(urls.length, ShenyuThreadFactory.create((String)"websocket-connect", (boolean)true));
        for (String url : urls) {
            try {
                this.clients.add(new ShenyuWebsocketClient(new URI(url), Objects.requireNonNull(pluginDataSubscriber), metaDataSubscribers, authDataSubscribers));
            }
            catch (URISyntaxException e) {
                LOG.error("websocket url({}) is error", (Object)url, (Object)e);
            }
        }
        try {
            for (WebSocketClient client : this.clients) {
                boolean success = client.connectBlocking(3000L, TimeUnit.MILLISECONDS);
                if (success) {
                    LOG.info("websocket connection is successful.....");
                } else {
                    LOG.error("websocket connection is error.....");
                }
                this.executor.scheduleAtFixedRate(() -> {
                    try {
                        if (client.isClosed()) {
                            boolean reconnectSuccess = client.reconnectBlocking();
                            if (reconnectSuccess) {
                                LOG.info("websocket reconnect server[{}] is successful.....", (Object)client.getURI().toString());
                            } else {
                                LOG.error("websocket reconnection server[{}] is error.....", (Object)client.getURI().toString());
                            }
                        } else {
                            client.sendPing();
                            LOG.debug("websocket send to [{}] ping message successful", (Object)client.getURI().toString());
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.error("websocket connect is error :{}", (Object)e.getMessage());
                    }
                }, 10L, 10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            LOG.info("websocket connection...exception....", (Throwable)e);
        }
    }

    @Override
    public void close() {
        for (WebSocketClient client : this.clients) {
            if (client.isClosed()) continue;
            client.close();
        }
        if (Objects.nonNull(this.executor)) {
            this.executor.shutdown();
        }
    }
}

