/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.metrics.reporter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shenyu.metrics.entity.Metric;
import org.apache.shenyu.metrics.spi.MetricsRegister;

public final class MetricsReporter {
    private static MetricsRegister metricsRegister;

    public static void register(MetricsRegister metricsRegister) {
        MetricsReporter.metricsRegister = metricsRegister;
        MetricsReporter.registerCounter("shenyu_request_total", "shenyu request total count");
        MetricsReporter.registerCounter("shenyu_http_request_total", new String[]{"path", "type"}, "shenyu http request type total count");
        MetricsReporter.registerHistogram("shenyu_execute_latency_millis", "the shenyu executor latency millis");
    }

    public static void registerMetrics(Collection<Metric> metrics) {
        block5: for (Metric metric : metrics) {
            switch (metric.getType()) {
                case COUNTER: {
                    MetricsReporter.registerCounter(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
                case GAUGE: {
                    MetricsReporter.registerGauge(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
                case HISTOGRAM: {
                    MetricsReporter.registerHistogram(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
            }
            throw new RuntimeException("we not support metric registration for type: " + (Object)((Object)metric.getType()));
        }
    }

    public static void registerCounter(String name, String[] labelNames, String document) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.registerCounter(name, labelNames, document));
    }

    public static void registerCounter(String name, String document) {
        MetricsReporter.registerCounter(name, null, document);
    }

    public static void registerGauge(String name, String[] labelNames, String document) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.registerGauge(name, labelNames, document));
    }

    public static void registerGauge(String name, String document) {
        MetricsReporter.registerGauge(name, null, document);
    }

    public static void registerHistogram(String name, String[] labelNames, String document) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.registerHistogram(name, labelNames, document));
    }

    public static void registerHistogram(String name, String document) {
        MetricsReporter.registerHistogram(name, null, document);
    }

    public static void counterIncrement(String name, String[] labelValues) {
        MetricsReporter.counterIncrement(name, labelValues, 1L);
    }

    public static void counterIncrement(String name) {
        MetricsReporter.counterIncrement(name, null, 1L);
    }

    public static void counterIncrement(String name, String[] labelValues, long count) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.counterIncrement(name, labelValues, count));
    }

    public static void gaugeIncrement(String name, String[] labelValues) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.gaugeIncrement(name, labelValues));
    }

    public static void gaugeIncrement(String name) {
        MetricsReporter.gaugeIncrement(name, null);
    }

    public static void gaugeDecrement(String name, String[] labelValues) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.gaugeDecrement(name, labelValues));
    }

    public static void gaugeDecrement(String name) {
        MetricsReporter.gaugeDecrement(name, null);
    }

    public static void recordTime(String name, String[] labelValues, long duration) {
        Optional.ofNullable(metricsRegister).ifPresent(register -> register.recordTime(name, labelValues, duration));
    }

    public static void recordTime(String name, long duration) {
        MetricsReporter.recordTime(name, null, duration);
    }

    public static void clean() {
        Optional.ofNullable(metricsRegister).ifPresent(MetricsRegister::clean);
        metricsRegister = null;
    }

    private static String[] getLabelNames(List<String> labels) {
        return labels.toArray(new String[0]);
    }
}

