/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.monitor;

import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.metrics.reporter.MetricsReporter;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MonitorPlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        MetricsReporter.counterIncrement((String)"shenyu_request_total");
        MetricsReporter.counterIncrement((String)"shenyu_http_request_total", (String[])new String[]{exchange.getRequest().getURI().getPath(), exchange.getRequest().getMethodValue()});
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        LocalDateTime startDateTime = Optional.ofNullable(shenyuContext).map(ShenyuContext::getStartDateTime).orElseGet(LocalDateTime::now);
        return chain.execute(exchange).doOnSuccess(e -> this.responseCommitted(exchange, startDateTime)).doOnError(throwable -> this.responseCommitted(exchange, startDateTime));
    }

    public int getOrder() {
        return PluginEnum.MONITOR.getCode();
    }

    public String named() {
        return PluginEnum.MONITOR.getName();
    }

    private void responseCommitted(ServerWebExchange exchange, LocalDateTime startDateTime) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            this.recordTime(startDateTime);
        } else {
            response.beforeCommit(() -> {
                this.recordTime(startDateTime);
                return Mono.empty();
            });
        }
    }

    private void recordTime(LocalDateTime startDateTime) {
        long millisBetween = DateUtils.acquireMillisBetween((LocalDateTime)startDateTime, (LocalDateTime)LocalDateTime.now());
        MetricsReporter.recordTime((String)"shenyu_execute_latency_millis", (long)millisBetween);
    }
}

