/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.spi;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import java.util.ServiceLoader;

public final class ServiceLoaderUtil {
    private static final String CLASSLOADER_DEFAULT = "default";
    private static final String CLASSLOADER_CONTEXT = "context";

    public static <S> ServiceLoader<S> getServiceLoader(Class<S> clazz) {
        if (ServiceLoaderUtil.shouldUseContextClassloader()) {
            return ServiceLoader.load(clazz);
        }
        return ServiceLoader.load(clazz, clazz.getClassLoader());
    }

    public static boolean shouldUseContextClassloader() {
        String classloaderConf = SentinelConfig.getConfig("csp.sentinel.spi.classloader");
        return CLASSLOADER_CONTEXT.equalsIgnoreCase(classloaderConf);
    }

    private ServiceLoaderUtil() {
    }
}

