/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;

public class SampleCountProperty {
    public static volatile int SAMPLE_COUNT = 2;

    public static void register2Property(SentinelProperty<Integer> property) {
        property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

            @Override
            public void configUpdate(Integer value) {
                if (value != null) {
                    SampleCountProperty.updateSampleCount(value);
                }
            }
        });
    }

    public static void updateSampleCount(int newSampleCount) {
        if (newSampleCount != SAMPLE_COUNT) {
            SAMPLE_COUNT = newSampleCount;
            ClusterBuilderSlot.resetClusterNodes();
        }
        RecordLog.info("SAMPLE_COUNT updated to: " + SAMPLE_COUNT, new Object[0]);
    }
}

