/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.context.path;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.context.path.handler.ContextPathPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ContextPathPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ContextPathPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        ContextMappingRuleHandle contextMappingRuleHandle = (ContextMappingRuleHandle)ContextPathPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(contextMappingRuleHandle)) {
            LOG.error("context path rule configuration is null \uff1a{}", (Object)rule);
            return chain.execute(exchange);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contextMappingRuleHandle.getContextPath()}) && !shenyuContext.getPath().startsWith(contextMappingRuleHandle.getContextPath())) {
            LOG.error("the context path '{}' is invalid.", (Object)contextMappingRuleHandle.getContextPath());
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.CONTEXT_PATH_ERROR.getCode(), (String)String.format("%s [invalid context path:'%s']", ShenyuResultEnum.CONTEXT_PATH_ERROR.getMsg(), contextMappingRuleHandle.getContextPath()), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        this.buildContextPath(shenyuContext, contextMappingRuleHandle);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.CONTEXT_PATH.getCode();
    }

    public String named() {
        return PluginEnum.CONTEXT_PATH.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        ShenyuContext body = (ShenyuContext)exchange.getAttribute("context");
        assert (body != null);
        String rpcType = body.getRpcType();
        return Objects.equals(rpcType, RpcTypeEnum.DUBBO.getName()) || Objects.equals(rpcType, RpcTypeEnum.GRPC.getName()) || Objects.equals(rpcType, RpcTypeEnum.TARS.getName()) || Objects.equals(rpcType, RpcTypeEnum.MOTAN.getName()) || Objects.equals(rpcType, RpcTypeEnum.SOFA.getName());
    }

    private void buildContextPath(ShenyuContext context, ContextMappingRuleHandle handle) {
        String realURI = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{handle.getContextPath()})) {
            context.setContextPath(handle.getContextPath());
            context.setModule(handle.getContextPath());
            realURI = context.getPath().substring(handle.getContextPath().length());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{handle.getAddPrefix()})) {
            realURI = StringUtils.isNotBlank((CharSequence)realURI) ? handle.getAddPrefix() + realURI : handle.getAddPrefix() + context.getPath();
        }
        context.setRealUrl(realURI);
    }
}

