/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sentinel.fallback;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.fallback.FallbackHandler;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SentinelFallbackHandler
implements FallbackHandler {
    public Mono<Void> generateError(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof DegradeException) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        } else if (throwable instanceof FlowException) {
            exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.TOO_MANY_REQUESTS.getCode(), (String)ShenyuResultEnum.TOO_MANY_REQUESTS.getMsg(), null);
        } else if (throwable instanceof BlockException) {
            exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
            error = ShenyuResultWrap.error((int)ShenyuResultEnum.SENTINEL_BLOCK_ERROR.getCode(), (String)ShenyuResultEnum.SENTINEL_BLOCK_ERROR.getMsg(), null);
        } else {
            return Mono.error((Throwable)throwable);
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

