/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt.handle;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;

public class JwtPluginDataHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        Map configMap = GsonUtils.getInstance().toObjectMap(pluginData.getConfig(), String.class);
        String secretKey = Optional.ofNullable(configMap.get("secretKey")).orElse("");
        String filterPath = Optional.ofNullable(configMap.get("filterPath")).orElse("");
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setSecretKey(secretKey);
        jwtConfig.setFilterPath(Arrays.asList(StringUtils.split((String)filterPath, (String)",")));
        Singleton.INST.single(JwtConfig.class, (Object)jwtConfig);
    }

    public String pluginNamed() {
        return PluginEnum.JWT.getName();
    }
}

