/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final String TOKEN = "token";
    private static final String AUTH2_TOKEN = "Bearer";

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        String token = exchange.getRequest().getHeaders().getFirst(TOKEN);
        String path = exchange.getRequest().getURI().getPath();
        List<String> filterPath = jwtConfig.getFilterPath();
        if (CollectionUtils.isNotEmpty(filterPath) && filterPath.contains(path)) {
            return chain.execute(exchange);
        }
        if (StringUtils.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SECRET_KEY_MUST_BE_CONFIGURED.getCode(), (String)ShenyuResultEnum.SECRET_KEY_MUST_BE_CONFIGURED.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String finalAuthorization = this.compatible(token, authorization);
        return this.checkAuthorization(exchange, chain, finalAuthorization, jwtConfig.getSecretKey());
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (StringUtils.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return finalAuthorization.contains(AUTH2_TOKEN) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private Mono<Void> checkAuthorization(ServerWebExchange exchange, ShenyuPluginChain chain, String authorization, String secretKey) {
        Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.ERROR_TOKEN.getCode(), (String)ShenyuResultEnum.ERROR_TOKEN.getMsg(), null);
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        JwtParser jwtParser = Jwts.parser();
        if (jwtParser.isSigned(authorization)) {
            jwtParser.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            return ThrowingFunction.wrap(() -> jwtParser.parse(authorization)) == null ? WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error) : chain.execute(exchange);
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

