/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.redirect;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.RedirectHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.redirect.handler.RedirectPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectPlugin
extends AbstractShenyuPlugin {
    public static final String ROOT_PATH_PREFIX = "/";
    private static final Logger LOG = LoggerFactory.getLogger(RedirectPlugin.class);
    private final DispatcherHandler dispatcherHandler;

    public RedirectPlugin(DispatcherHandler dispatcherHandler) {
        this.dispatcherHandler = dispatcherHandler;
    }

    public int getOrder() {
        return PluginEnum.REDIRECT.getCode();
    }

    public String named() {
        return PluginEnum.REDIRECT.getName();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String handle = rule.getHandle();
        RedirectHandle redirectHandle = (RedirectHandle)RedirectPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(redirectHandle) || StringUtils.isBlank((CharSequence)redirectHandle.getRedirectURI())) {
            LOG.error("uri redirect rule can not configuration: {}", (Object)handle);
            return chain.execute(exchange);
        }
        if (redirectHandle.getRedirectURI().startsWith(ROOT_PATH_PREFIX)) {
            ServerHttpRequest request = exchange.getRequest().mutate().uri(Objects.requireNonNull(UriUtils.createUri((String)redirectHandle.getRedirectURI()))).build();
            ServerWebExchange mutated = exchange.mutate().request(request).build();
            return this.dispatcherHandler.handle(mutated);
        }
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.PERMANENT_REDIRECT);
        response.getHeaders().add("Location", redirectHandle.getRedirectURI());
        return response.setComplete();
    }
}

