/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient.config;

import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ResourceUtils;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;

public class HttpClientProperties {
    private Integer connectTimeout;
    private Duration responseTimeout;
    private Integer readTimeout = 3000;
    private Integer writeTimeout = 3000;
    private Pool pool = new Pool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();
    private boolean wiretap;

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Integer writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public boolean isWiretap() {
        return this.wiretap;
    }

    public void setWiretap(boolean wiretap) {
        this.wiretap = wiretap;
    }

    public class Ssl {
        private boolean useInsecureTrustManager;
        private List<String> trustedX509Certificates = new ArrayList<String>();
        private Duration handshakeTimeout = Duration.ofMillis(10000L);
        private Duration closeNotifyFlushTimeout = Duration.ofMillis(3000L);
        private Duration closeNotifyReadTimeout = Duration.ZERO;
        private SslProvider.DefaultConfigurationType defaultConfigurationType = SslProvider.DefaultConfigurationType.TCP;

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public List<String> getTrustedX509Certificates() {
            return this.trustedX509Certificates;
        }

        public void setTrustedX509Certificates(List<String> trustedX509Certificates) {
            this.trustedX509Certificates = trustedX509Certificates;
        }

        public Duration getHandshakeTimeout() {
            return this.handshakeTimeout;
        }

        public void setHandshakeTimeout(Duration handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
        }

        public Duration getCloseNotifyFlushTimeout() {
            return this.closeNotifyFlushTimeout;
        }

        public void setCloseNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            this.closeNotifyFlushTimeout = closeNotifyFlushTimeout;
        }

        public Duration getCloseNotifyReadTimeout() {
            return this.closeNotifyReadTimeout;
        }

        public void setCloseNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            this.closeNotifyReadTimeout = closeNotifyReadTimeout;
        }

        public SslProvider.DefaultConfigurationType getDefaultConfigurationType() {
            return this.defaultConfigurationType;
        }

        public void setDefaultConfigurationType(SslProvider.DefaultConfigurationType defaultConfigurationType) {
            this.defaultConfigurationType = defaultConfigurationType;
        }

        public X509Certificate[] getTrustedX509CertificatesForTrustManager() {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
                for (String trustedCert : HttpClientProperties.this.ssl.getTrustedX509Certificates()) {
                    try {
                        URL url = ResourceUtils.getURL((String)trustedCert);
                        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(url.openStream());
                        allCerts.addAll(certs);
                    }
                    catch (IOException e) {
                        throw new WebServerException("Could not load certificate '" + trustedCert + "'", (Throwable)e);
                    }
                }
                X509Certificate[] x509Certificates = new X509Certificate[allCerts.size()];
                return allCerts.toArray(x509Certificates);
            }
            catch (CertificateException e) {
                throw new WebServerException("Could not load CertificateFactory X.509", (Throwable)e);
            }
        }
    }

    public static class Proxy {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "proxy";
        private Integer maxConnections = ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS;
        private Long acquireTimeout = ConnectionProvider.DEFAULT_POOL_ACQUIRE_TIMEOUT;

        public PoolType getType() {
            return this.type;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }
    }
}

