/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import io.netty.channel.ConnectTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.retry.Backoff;
import reactor.retry.Retry;

public class WebClientPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(WebClientPlugin.class);
    private final WebClient webClient;

    public WebClientPlugin(WebClient webClient) {
        this.webClient = webClient;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        String urlPath = (String)exchange.getAttribute("httpUrl");
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.CANNOT_FIND_URL.getCode(), (String)ShenyuResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        int retryTimes = (Integer)Optional.ofNullable(exchange.getAttribute("httpRetry")).orElse(0);
        LOG.info("The request urlPath is {}, retryTimes is {}", (Object)urlPath, (Object)retryTimes);
        HttpMethod method = HttpMethod.valueOf((String)exchange.getRequest().getMethodValue());
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)this.webClient.method(method).uri(urlPath, new Object[0]);
        return this.handleRequestBody(requestBodySpec, exchange, timeout, retryTimes, chain);
    }

    public int getOrder() {
        return PluginEnum.WEB_CLIENT.getCode();
    }

    public String named() {
        return PluginEnum.WEB_CLIENT.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), shenyuContext.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), shenyuContext.getRpcType());
    }

    private Mono<Void> handleRequestBody(WebClient.RequestBodySpec requestBodySpec, ServerWebExchange exchange, long timeout, int retryTimes, ShenyuPluginChain chain) {
        return ((WebClient.RequestBodySpec)requestBodySpec.headers(httpHeaders -> {
            httpHeaders.addAll((MultiValueMap)exchange.getRequest().getHeaders());
            httpHeaders.remove((Object)"Host");
        })).body(BodyInserters.fromDataBuffers((Publisher)exchange.getRequest().getBody())).exchange().doOnError(e -> LOG.error(e.getMessage(), e)).timeout(Duration.ofMillis(timeout)).retryWhen((Function)Retry.onlyIf(x -> x.exception() instanceof ConnectTimeoutException).retryMax((long)retryTimes).backoff(Backoff.exponential((Duration)Duration.ofMillis(200L), (Duration)Duration.ofSeconds(20L), (int)2, (boolean)true))).flatMap(e -> this.doNext((ClientResponse)e, exchange, chain));
    }

    private Mono<Void> doNext(ClientResponse res, ServerWebExchange exchange, ShenyuPluginChain chain) {
        if (res.statusCode().is2xxSuccessful()) {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        } else {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
        }
        exchange.getAttributes().put("webHandlerClientResponse", res);
        return chain.execute(exchange);
    }
}

