/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.entity;

import java.util.Objects;

public final class Upstream {
    private String protocol;
    private String url;
    private int weight;
    private boolean status;
    private long timestamp;
    private int warmup;
    private boolean healthy;
    private long lastHealthTimestamp;
    private long lastUnhealthyTimestamp;
    private String group;
    private String version;

    private Upstream(Builder builder) {
        this.protocol = builder.protocol;
        this.url = builder.url;
        this.weight = builder.weight;
        this.status = builder.status;
        this.timestamp = builder.timestamp;
        this.warmup = builder.warmup;
        this.group = builder.group;
        this.version = builder.version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public long getLastHealthTimestamp() {
        return this.lastHealthTimestamp;
    }

    public void setLastHealthTimestamp(long lastHealthTimestamp) {
        this.lastHealthTimestamp = lastHealthTimestamp;
    }

    public long getLastUnhealthyTimestamp() {
        return this.lastUnhealthyTimestamp;
    }

    public void setLastUnhealthyTimestamp(long lastUnhealthyTimestamp) {
        this.lastUnhealthyTimestamp = lastUnhealthyTimestamp;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Upstream that = (Upstream)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.weight, that.weight);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.url, this.weight);
    }

    public String toString() {
        return "Upstream{protocol='" + this.protocol + ", url='" + this.url + ", weight=" + this.weight + ", status=" + this.status + ", timestamp=" + this.timestamp + ", warmup=" + this.warmup + ", group='" + this.group + ", version='" + this.version + '}';
    }

    public static final class Builder {
        private String protocol;
        private String url;
        private int weight = 50;
        private boolean status = true;
        private long timestamp;
        private int warmup = 600000;
        private String group;
        private String version;

        private Builder() {
        }

        public Upstream build() {
            return new Upstream(this);
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.status = status;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder warmup(int warmup) {
            this.warmup = warmup;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }
    }
}

