/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.algorithm;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.plugin.ratelimiter.algorithm.RateLimiterAlgorithm;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public abstract class AbstractRateLimiterAlgorithm
implements RateLimiterAlgorithm<List<Long>> {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private RedisScript<List<Long>> script;

    protected abstract String getScriptName();

    protected abstract String getKeyName();

    @Override
    public RedisScript<List<Long>> getScript() {
        if (!this.initialized.get()) {
            DefaultRedisScript redisScript = new DefaultRedisScript();
            String scriptPath = "/META-INF/scripts/" + this.getScriptName();
            redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource(scriptPath)));
            redisScript.setResultType(List.class);
            this.script = redisScript;
            this.initialized.compareAndSet(false, true);
            return redisScript;
        }
        return this.script;
    }

    @Override
    public List<String> getKeys(String id) {
        String prefix = this.getKeyName() + ".{" + id;
        String tokenKey = prefix + "}.tokens";
        String timestampKey = prefix + "}.timestamp";
        return Arrays.asList(tokenKey, timestampKey);
    }
}

