/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter;

import java.util.Optional;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.RateLimiterHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.ratelimiter.executor.RedisRateLimiter;
import org.apache.shenyu.plugin.ratelimiter.handler.RateLimiterPluginDataHandler;
import org.apache.shenyu.plugin.ratelimiter.resolver.RateLimiterKeyResolverFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RateLimiterPlugin
extends AbstractShenyuPlugin {
    private final RedisRateLimiter redisRateLimiter;

    public RateLimiterPlugin(RedisRateLimiter redisRateLimiter) {
        this.redisRateLimiter = redisRateLimiter;
    }

    public String named() {
        return PluginEnum.RATE_LIMITER.getName();
    }

    public int getOrder() {
        return PluginEnum.RATE_LIMITER.getCode();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        RateLimiterHandle limiterHandle = (RateLimiterHandle)RateLimiterPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        String resolverKey = Optional.ofNullable(limiterHandle.getKeyResolverName()).flatMap(name -> Optional.of("-" + RateLimiterKeyResolverFactory.newInstance(name).resolve(exchange))).orElse("");
        return this.redisRateLimiter.isAllowed(rule.getId() + resolverKey, limiterHandle).flatMap(response -> {
            if (!response.isAllowed()) {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.TOO_MANY_REQUESTS.getCode(), (String)ShenyuResultEnum.TOO_MANY_REQUESTS.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            return chain.execute(exchange);
        });
    }
}

