/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SignPlugin
extends AbstractShenyuPlugin {
    private final SignService signService;

    public SignPlugin(SignService signService) {
        this.signService = signService;
    }

    public String named() {
        return PluginEnum.SIGN.getName();
    }

    public int getOrder() {
        return PluginEnum.SIGN.getCode();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        Pair<Boolean, String> result = this.signService.signVerify(exchange);
        if (!((Boolean)result.getLeft()).booleanValue()) {
            Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)((String)result.getRight()), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(exchange);
    }
}

