/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.etcd;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.etcd.EtcdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdSyncDataService
implements SyncDataService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdSyncDataService.class);
    private final EtcdClient etcdClient;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public EtcdSyncDataService(EtcdClient etcdClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.etcdClient = etcdClient;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.watcherData();
        this.watchAppAuth();
        this.watchMetaData();
    }

    private void watcherData() {
        String pluginParent = "/shenyu/plugin";
        List<String> pluginChildren = this.etcdClientGetChildren("/shenyu/plugin");
        for (String pluginName : pluginChildren) {
            this.watcherAll(pluginName);
        }
        this.etcdClient.watchChildChange("/shenyu/plugin", (updateNode, updateValue) -> {
            if (!updateNode.isEmpty()) {
                this.watcherAll((String)updateNode);
            }
        }, null);
    }

    private void watcherAll(String pluginName) {
        this.watcherPlugin(pluginName);
        this.watcherSelector(pluginName);
        this.watcherRule(pluginName);
    }

    private void watcherPlugin(String pluginName) {
        String pluginPath = DefaultPathConstants.buildPluginPath((String)pluginName);
        this.cachePluginData(this.etcdClient.get(pluginPath));
        this.subscribePluginDataChanges(pluginPath, pluginName);
    }

    private void watcherSelector(String pluginName) {
        String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)pluginName);
        List<String> childrenList = this.etcdClientGetChildren(selectorParentPath);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(selectorParentPath, (String)children);
                this.cacheSelectorData(this.etcdClient.get(realPath));
                this.subscribeSelectorDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.SELECTOR, selectorParentPath);
    }

    private void watcherRule(String pluginName) {
        String ruleParent = DefaultPathConstants.buildRuleParentPath((String)pluginName);
        List<String> childrenList = this.etcdClientGetChildren(ruleParent);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(ruleParent, (String)children);
                this.cacheRuleData(this.etcdClient.get(realPath));
                this.subscribeRuleDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.RULE, ruleParent);
    }

    private void watchAppAuth() {
        String appAuthParent = "/shenyu/auth";
        List<String> childrenList = this.etcdClientGetChildren("/shenyu/auth");
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/shenyu/auth", (String)children);
                this.cacheAuthData(this.etcdClient.get(realPath));
                this.subscribeAppAuthDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.APP_AUTH, "/shenyu/auth");
    }

    private void watchMetaData() {
        String metaDataPath = "/shenyu/metaData";
        List<String> childrenList = this.etcdClientGetChildren("/shenyu/metaData");
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/shenyu/metaData", (String)children);
                this.cacheMetaData(this.etcdClient.get(realPath));
                this.subscribeMetaDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.META_DATA, "/shenyu/metaData");
    }

    private void subscribeChildChanges(ConfigGroupEnum groupKey, String groupParentPath) {
        switch (groupKey) {
            case SELECTOR: {
                this.etcdClient.watchChildChange(groupParentPath, (updatePath, updateValue) -> {
                    this.cacheSelectorData(this.etcdClient.get((String)updatePath));
                    this.subscribeSelectorDataChanges((String)updatePath);
                }, null);
                break;
            }
            case RULE: {
                this.etcdClient.watchChildChange(groupParentPath, (updatePath, updateValue) -> {
                    this.cacheRuleData(this.etcdClient.get((String)updatePath));
                    this.subscribeRuleDataChanges((String)updatePath);
                }, null);
                break;
            }
            case APP_AUTH: {
                this.etcdClient.watchChildChange(groupParentPath, (updatePath, updateValue) -> {
                    this.cacheAuthData(this.etcdClient.get((String)updatePath));
                    this.subscribeAppAuthDataChanges((String)updatePath);
                }, null);
                break;
            }
            case META_DATA: {
                this.etcdClient.watchChildChange(groupParentPath, (updatePath, updateValue) -> {
                    this.cacheMetaData(this.etcdClient.get((String)updatePath));
                    this.subscribeMetaDataChanges((String)updatePath);
                }, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected groupKey: " + groupKey);
            }
        }
    }

    private void subscribePluginDataChanges(String pluginPath, String pluginName) {
        this.etcdClient.watchDataChange(pluginPath, (updatePath, updateValue) -> {
            String dataPath = this.buildRealPath(pluginPath, (String)updatePath);
            String dataStr = this.etcdClient.get(dataPath);
            PluginData data = (PluginData)GsonUtils.getInstance().fromJson(dataStr, PluginData.class);
            Optional.ofNullable(data).ifPresent(d -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSubscribe(d)));
        }, deleteNode -> this.deletePlugin(pluginName));
    }

    private void deletePlugin(String pluginName) {
        PluginData data = new PluginData();
        data.setName(pluginName);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(data));
    }

    private void subscribeSelectorDataChanges(String path) {
        this.etcdClient.watchDataChange(path, (updateNode, updateValue) -> this.cacheSelectorData((String)updateValue), this::unCacheSelectorData);
    }

    private void subscribeRuleDataChanges(String path) {
        this.etcdClient.watchDataChange(path, (updatePath, updateValue) -> this.cacheRuleData((String)updateValue), this::unCacheRuleData);
    }

    private void subscribeAppAuthDataChanges(String realPath) {
        this.etcdClient.watchDataChange(realPath, (updatePath, updateValue) -> this.cacheAuthData((String)updateValue), this::unCacheAuthData);
    }

    private void subscribeMetaDataChanges(String realPath) {
        this.etcdClient.watchDataChange(realPath, (updatePath, updateValue) -> this.cacheMetaData((String)updateValue), this::deleteMetaData);
    }

    private void deleteMetaData(String deletePath) {
        String path = deletePath.substring("/shenyu/metaData".length() + 1);
        MetaData metaData = new MetaData();
        try {
            metaData.setPath(URLDecoder.decode(path, StandardCharsets.UTF_8.name()));
            this.unCacheMetaData(metaData);
            this.etcdClient.watchClose(path);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void cachePluginData(String dataString) {
        PluginData pluginData = (PluginData)GsonUtils.getInstance().fromJson(dataString, PluginData.class);
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
    }

    private void cacheSelectorData(String dataString) {
        SelectorData selectorData = (SelectorData)GsonUtils.getInstance().fromJson(dataString, SelectorData.class);
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe(data)));
    }

    private void unCacheSelectorData(String dataPath) {
        SelectorData selectorData = new SelectorData();
        String selectorId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/selector".length());
        String pluginName = str.substring(1, str.length() - selectorId.length() - 1);
        selectorData.setPluginName(pluginName);
        selectorData.setId(selectorId);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
        this.etcdClient.watchClose(dataPath);
    }

    private void cacheRuleData(String dataString) {
        RuleData ruleData = (RuleData)GsonUtils.getInstance().fromJson(dataString, RuleData.class);
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe(data)));
    }

    private void unCacheRuleData(String dataPath) {
        String substring = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/rule".length());
        String pluginName = str.substring(1, str.length() - substring.length() - 1);
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)substring));
        RuleData ruleData = new RuleData();
        ruleData.setPluginName(pluginName);
        ruleData.setSelectorId((String)list.get(0));
        ruleData.setId((String)list.get(1));
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
        this.etcdClient.watchClose(dataPath);
    }

    private void cacheAuthData(String dataString) {
        AppAuthData appAuthData = (AppAuthData)GsonUtils.getInstance().fromJson(dataString, AppAuthData.class);
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe(data)));
    }

    private void unCacheAuthData(String dataPath) {
        String key = dataPath.substring("/shenyu/auth".length() + 1);
        AppAuthData appAuthData = new AppAuthData();
        appAuthData.setAppKey(key);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
        this.etcdClient.watchClose(dataPath);
    }

    private void cacheMetaData(String dataString) {
        MetaData metaData = (MetaData)GsonUtils.getInstance().fromJson(dataString, MetaData.class);
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    private void unCacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData)));
    }

    private String buildRealPath(String parent, String children) {
        return String.join((CharSequence)"/", parent, children);
    }

    private List<String> etcdClientGetChildren(String parent) {
        try {
            return this.etcdClient.getChildrenKeys(parent, "/");
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void close() {
        if (null != this.etcdClient) {
            this.etcdClient.close();
        }
    }
}

