/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.param.mapping;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ParamMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.param.mapping.handler.ParamMappingPluginDataHandler;
import org.apache.shenyu.plugin.param.mapping.strategy.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ParamMappingPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ParamMappingPlugin.class);
    private final Map<String, Operator> operatorMap;

    public ParamMappingPlugin(Map<String, Operator> operatorMap) {
        this.operatorMap = operatorMap;
    }

    public Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ParamMappingRuleHandle paramMappingRuleHandle = (ParamMappingRuleHandle)ParamMappingPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(paramMappingRuleHandle)) {
            LOG.error("param mapping rule configuration is null :{}", (Object)rule.getId());
            return chain.execute(exchange);
        }
        HttpHeaders headers = exchange.getRequest().getHeaders();
        MediaType contentType = headers.getContentType();
        return this.match(contentType).apply(exchange, chain, paramMappingRuleHandle);
    }

    public int getOrder() {
        return PluginEnum.PARAM_MAPPING.getCode();
    }

    public String named() {
        return PluginEnum.PARAM_MAPPING.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return false;
    }

    private Operator match(MediaType mediaType) {
        if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            return this.operatorMap.get(MediaType.APPLICATION_JSON.toString());
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
            return this.operatorMap.get(MediaType.APPLICATION_FORM_URLENCODED.toString());
        }
        return this.operatorMap.get("DEFAULT");
    }
}

