/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectUtils.class);

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = beanClass.getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (null == obj || StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (null == obj || null == field) {
            return null;
        }
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            LOG.error("", (Throwable)e);
        }
        return result;
    }

    public static Object invokeMethod(Class<?> clazz, String method) {
        try {
            Method m = ReflectUtils.findMethod(clazz, method);
            assert (m != null);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static Method findMethod(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to assign to the element.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }
}

