/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClusterClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcSdkClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RpcClientFactory {
    static Map<String, RpcClient> clientMap = new HashMap<String, RpcClient>();

    public static Set<Map.Entry<String, RpcClient>> getAllClientEntries() {
        Set<Map.Entry<String, RpcClient>> entries = clientMap.entrySet();
        return entries;
    }

    public static void destroyClient(String clientName) throws NacosException {
        RpcClient rpcClient = clientMap.remove(clientName);
        if (rpcClient != null) {
            rpcClient.shutdown();
        }
    }

    public static RpcClient getClient(String clientName) {
        return clientMap.get(clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcClient createClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        String clientNameInner = clientName;
        Map<String, RpcClient> map = clientMap;
        synchronized (map) {
            if (clientMap.get(clientNameInner) == null) {
                GrpcSdkClient moduleClient = null;
                if (ConnectionType.GRPC.equals((Object)connectionType)) {
                    moduleClient = new GrpcSdkClient(clientNameInner);
                }
                if (moduleClient == null) {
                    throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
                }
                moduleClient.labels(labels);
                clientMap.put(clientNameInner, moduleClient);
                return moduleClient;
            }
            return clientMap.get(clientNameInner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        String clientNameInner = clientName;
        Map<String, RpcClient> map = clientMap;
        synchronized (map) {
            if (clientMap.get(clientNameInner) == null) {
                GrpcClusterClient moduleClient = null;
                if (ConnectionType.GRPC.equals((Object)connectionType)) {
                    moduleClient = new GrpcClusterClient(clientNameInner);
                }
                if (moduleClient == null) {
                    throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
                }
                moduleClient.labels(labels);
                clientMap.put(clientNameInner, moduleClient);
                return moduleClient;
            }
            return clientMap.get(clientNameInner);
        }
    }
}

