/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Md5Utils.class);

    private static String md5(String src, String charset) {
        byte[] md5Bytes;
        MessageDigest md5;
        StringBuilder hexValue = new StringBuilder(32);
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ShenyuException("MD5 not supported", e);
        }
        byte[] byteArray = new byte[]{};
        try {
            byteArray = src.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        for (byte md5Byte : md5Bytes = md5.digest(byteArray)) {
            int val = md5Byte & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String md5(String src) {
        return Md5Utils.md5(src, StandardCharsets.UTF_8.name());
    }
}

