/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shenyu.common.exception.ShenyuException;

public class CipherUtils {
    public static final String AES_CBC_PKCS_5_PADDING = "AES/CBC/PKCS5Padding";

    private static byte[] cipherTool(byte[] content, int mode, String aesKey, String iv) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS_5_PADDING);
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
            cipher.init(mode, (Key)keySpec, ivSpec);
            byte[] plainText = content;
            return cipher.doFinal(plainText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public static String encryptHex(String src, String aesKey, String iv) {
        return Optional.ofNullable(src).map(item -> {
            try {
                byte[] byteContent = item.getBytes(StandardCharsets.UTF_8);
                byte[] result = CipherUtils.cipherTool(byteContent, 1, aesKey, iv);
                return Base64.getEncoder().encodeToString(result);
            }
            catch (Exception ex) {
                throw new ShenyuException((Throwable)ex);
            }
        }).orElse(null);
    }

    public static String decryptStr(String src, String aesKey, String iv) {
        return Optional.ofNullable(src).map(item -> {
            try {
                byte[] byteContent = Base64.getDecoder().decode((String)item);
                byte[] result = CipherUtils.cipherTool(byteContent, 2, aesKey, iv);
                return new String(result);
            }
            catch (Exception ex) {
                throw new ShenyuException((Throwable)ex);
            }
        }).orElse(null);
    }
}

