/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterDubboServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    @Override
    public String rpcType() {
        return RpcTypeEnum.DUBBO.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return new DubboRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        MetaDataDO exist = metaDataService.findByPath(metaDataDTO.getPath());
        metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        String handleAdd;
        List<DubboUpstream> addList = this.buildDubboUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        if (StringUtils.isBlank((CharSequence)selectorDO.getHandle())) {
            handleAdd = GsonUtils.getInstance().toJson(addList);
            canAddList = addList;
        } else {
            List existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), DubboUpstream.class);
            for (DubboUpstream exist : existList) {
                for (DubboUpstream add : addList) {
                    if (exist.getUpstreamUrl().equals(add.getUpstreamUrl())) continue;
                    existList.add(add);
                    canAddList.add(add);
                }
            }
            handleAdd = GsonUtils.getInstance().toJson((Object)existList);
        }
        this.doSubmit(selectorDO.getId(), canAddList);
        return handleAdd;
    }

    private List<DubboUpstream> buildDubboUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDefaultDubboUpstream(dto.getHost(), dto.getPort())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }
}

