/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.DataPermissionDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleConditionDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RuleConditionQuery;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.vo.RuleConditionVO;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.constant.AdminConstants;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements RuleService {
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final SelectorMapper selectorMapper;
    private final PluginMapper pluginMapper;
    private final DataPermissionMapper dataPermissionMapper;
    private final ApplicationEventPublisher eventPublisher;

    public RuleServiceImpl(RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, SelectorMapper selectorMapper, PluginMapper pluginMapper, DataPermissionMapper dataPermissionMapper, ApplicationEventPublisher eventPublisher) {
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.selectorMapper = selectorMapper;
        this.pluginMapper = pluginMapper;
        this.dataPermissionMapper = dataPermissionMapper;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public String registerDefault(RuleDTO ruleDTO) {
        RuleDO exist = this.ruleMapper.findBySelectorIdAndName(ruleDTO.getSelectorId(), ruleDTO.getName());
        if (Objects.nonNull(exist)) {
            return "";
        }
        RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
        List<RuleConditionDTO> ruleConditions = ruleDTO.getRuleConditions();
        if (StringUtils.isEmpty((CharSequence)ruleDTO.getId())) {
            this.ruleMapper.insertSelective(ruleDO);
            ruleConditions.forEach(ruleConditionDTO -> {
                ruleConditionDTO.setRuleId(ruleDO.getId());
                this.ruleConditionMapper.insertSelective(RuleConditionDO.buildRuleConditionDO(ruleConditionDTO));
            });
        }
        this.publishEvent(ruleDO, ruleConditions);
        return ruleDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(RuleDTO ruleDTO) {
        int ruleCount;
        RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
        List<RuleConditionDTO> ruleConditions = ruleDTO.getRuleConditions();
        if (StringUtils.isEmpty((CharSequence)ruleDTO.getId())) {
            ruleCount = this.ruleMapper.insertSelective(ruleDO);
            if (this.dataPermissionMapper.listByUserId(JwtUtils.getUserInfo().getUserId()).size() > 0) {
                DataPermissionDTO dataPermissionDTO = new DataPermissionDTO();
                dataPermissionDTO.setUserId(JwtUtils.getUserInfo().getUserId());
                dataPermissionDTO.setDataId(ruleDO.getId());
                dataPermissionDTO.setDataType(AdminConstants.RULE_DATA_TYPE);
                this.dataPermissionMapper.insertSelective(DataPermissionDO.buildPermissionDO(dataPermissionDTO));
            }
            ruleConditions.forEach(ruleConditionDTO -> {
                ruleConditionDTO.setRuleId(ruleDO.getId());
                this.ruleConditionMapper.insertSelective(RuleConditionDO.buildRuleConditionDO(ruleConditionDTO));
            });
        } else {
            ruleCount = this.ruleMapper.updateSelective(ruleDO);
            this.ruleConditionMapper.deleteByQuery(new RuleConditionQuery(ruleDO.getId()));
            ruleConditions.forEach(ruleConditionDTO -> {
                ruleConditionDTO.setRuleId(ruleDO.getId());
                RuleConditionDO ruleConditionDO = RuleConditionDO.buildRuleConditionDO(ruleConditionDTO);
                this.ruleConditionMapper.insertSelective(ruleConditionDO);
            });
        }
        this.publishEvent(ruleDO, ruleConditions);
        return ruleCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        for (String id : ids) {
            RuleDO ruleDO = this.ruleMapper.selectById(id);
            SelectorDO selectorDO = this.selectorMapper.selectById(ruleDO.getSelectorId());
            PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
            this.ruleMapper.delete(id);
            this.ruleConditionMapper.deleteByQuery(new RuleConditionQuery(id));
            this.dataPermissionMapper.deleteByDataId(id);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.DELETE, Collections.singletonList(RuleDO.transFrom(ruleDO, pluginDO.getName(), null))));
        }
        return ids.size();
    }

    @Override
    public RuleVO findById(String id) {
        return RuleVO.buildRuleVO(this.ruleMapper.selectById(id), this.ruleConditionMapper.selectByQuery(new RuleConditionQuery(id)).stream().map(RuleConditionVO::buildRuleConditionVO).collect(Collectors.toList()));
    }

    @Override
    @DataPermission(dataType="rule")
    @Pageable
    public CommonPager<RuleVO> listByPage(RuleQuery ruleQuery) {
        return PageResultUtils.result(ruleQuery.getPageParameter(), () -> this.ruleMapper.selectByQuery(ruleQuery).stream().map(RuleVO::buildRuleVO).collect(Collectors.toList()));
    }

    @Override
    public List<RuleData> listAll() {
        return this.ruleMapper.selectAll().stream().filter(Objects::nonNull).map(this::buildRuleData).collect(Collectors.toList());
    }

    @Override
    public List<RuleData> findBySelectorId(String selectorId) {
        return this.ruleMapper.findBySelectorId(selectorId).stream().filter(Objects::nonNull).map(this::buildRuleData).collect(Collectors.toList());
    }

    @Override
    public RuleDO findByName(String name) {
        return this.ruleMapper.findByName(name);
    }

    private void publishEvent(RuleDO ruleDO, List<RuleConditionDTO> ruleConditions) {
        SelectorDO selectorDO = this.selectorMapper.selectById(ruleDO.getSelectorId());
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List<ConditionData> conditionDataList = ruleConditions.stream().map(ConditionTransfer.INSTANCE::mapToRuleDTO).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.UPDATE, Collections.singletonList(RuleDO.transFrom(ruleDO, pluginDO.getName(), conditionDataList))));
    }

    private RuleData buildRuleData(RuleDO ruleDO) {
        List<ConditionData> conditions = this.ruleConditionMapper.selectByQuery(new RuleConditionQuery(ruleDO.getId())).stream().filter(Objects::nonNull).map(ConditionTransfer.INSTANCE::mapToRuleDO).collect(Collectors.toList());
        SelectorDO selectorDO = this.selectorMapper.selectById(ruleDO.getSelectorId());
        if (Objects.isNull(selectorDO)) {
            return null;
        }
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return RuleDO.transFrom(ruleDO, pluginDO.getName(), conditions);
    }
}

