/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.query.RuleConditionQuery;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.AdminPluginOperateEnum;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PluginServiceImpl
implements PluginService {
    private final PluginMapper pluginMapper;
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final ResourceService resourceService;

    public PluginServiceImpl(PluginMapper pluginMapper, SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, ApplicationEventPublisher eventPublisher, ResourceService resourceService) {
        this.pluginMapper = pluginMapper;
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.eventPublisher = eventPublisher;
        this.resourceService = resourceService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createOrUpdate(PluginDTO pluginDTO) {
        String msg = this.checkData(pluginDTO);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
            return msg;
        }
        PluginDO pluginDO = PluginDO.buildPluginDO(pluginDTO);
        DataEventTypeEnum eventType = DataEventTypeEnum.CREATE;
        if (StringUtils.isBlank((CharSequence)pluginDTO.getId())) {
            this.insertPluginDataToResource(pluginDTO);
            this.pluginMapper.insertSelective(pluginDO);
        } else {
            eventType = DataEventTypeEnum.UPDATE;
            this.pluginMapper.updateSelective(pluginDO);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, eventType, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(pluginDO))));
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        for (String id : ids) {
            PluginDO pluginDO = this.pluginMapper.selectById(id);
            if (Objects.isNull(pluginDO)) {
                return "The plugin id does not exist\uff01";
            }
            this.pluginMapper.delete(id);
            this.deletePluginDataFromResourceAndPermission(pluginDO.getName());
            List<SelectorDO> selectorDOList = this.selectorMapper.selectByQuery(new SelectorQuery(id, null, null));
            selectorDOList.forEach(selectorDO -> {
                List<RuleDO> ruleDOS = this.ruleMapper.selectByQuery(new RuleQuery(selectorDO.getId(), null, null));
                ruleDOS.forEach(ruleDO -> {
                    this.ruleMapper.delete(ruleDO.getId());
                    this.ruleConditionMapper.deleteByQuery(new RuleConditionQuery(ruleDO.getId()));
                });
                this.selectorMapper.delete(selectorDO.getId());
                this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
            });
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(pluginDO))));
        }
        return "";
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        for (String id : ids) {
            PluginDO pluginDO = this.pluginMapper.selectById(id);
            if (Objects.isNull(pluginDO)) {
                return "The plugin id does not exist\uff01";
            }
            pluginDO.setDateUpdated(new Timestamp(System.currentTimeMillis()));
            pluginDO.setEnabled(enabled);
            this.pluginMapper.updateEnable(pluginDO);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(pluginDO))));
        }
        return "";
    }

    @Override
    public PluginVO findById(String id) {
        return PluginVO.buildPluginVO(this.pluginMapper.selectById(id));
    }

    @Override
    @Pageable
    public CommonPager<PluginVO> listByPage(PluginQuery pluginQuery) {
        return PageResultUtils.result(pluginQuery.getPageParameter(), () -> this.pluginMapper.selectByQuery(pluginQuery).stream().map(PluginVO::buildPluginVO).collect(Collectors.toList()));
    }

    @Override
    public List<PluginData> listAll() {
        return this.pluginMapper.selectAll().stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList());
    }

    @Override
    public String selectIdByName(String name) {
        PluginDO pluginDO = this.pluginMapper.selectByName(name);
        Objects.requireNonNull(pluginDO);
        return pluginDO.getId();
    }

    @Override
    public PluginDO findByName(String name) {
        return this.pluginMapper.selectByName(name);
    }

    private String checkData(PluginDTO pluginDTO) {
        PluginDO exist = this.pluginMapper.selectByName(pluginDTO.getName());
        if (StringUtils.isBlank((CharSequence)pluginDTO.getId())) {
            if (Objects.nonNull(exist)) {
                return "The plugin name already exists and can't be added repeatedly!";
            }
        } else if (Objects.isNull(exist) || !exist.getId().equals(pluginDTO.getId())) {
            return "The plugin name not exist!";
        }
        return "";
    }

    private void deletePluginDataFromResourceAndPermission(String pluginName) {
        ResourceVO resourceVO = this.resourceService.findByTitle(pluginName);
        if (!ObjectUtils.isEmpty((Object)resourceVO)) {
            this.resourceService.delete(Collections.singletonList(resourceVO.getId()));
        }
    }

    private void insertPluginDataToResource(PluginDTO pluginDTO) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(ResourceDTO.builder().parentId("1346775491550474240").title(pluginDTO.getName()).name(pluginDTO.getName()).url("/plug/" + pluginDTO.getName()).component(pluginDTO.getName()).resourceType(AdminResourceEnum.SECOND_MENU.getCode()).sort(0).icon("block").isLeaf(Boolean.FALSE).isRoute(0).status(1).perms("").build());
        this.insertPluginMenuResource(resourceDO);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.ADD);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.DELETE);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.EDIT);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.QUERY);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.ADD);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.DELETE);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.EDIT);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.QUERY);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.PLUGIN, AdminPluginOperateEnum.SYNCHRONIZE);
    }

    private void insertPluginMenuResource(ResourceDO resourceDO) {
        this.resourceService.createResource(resourceDO);
    }

    private void insertPluginButtonResource(String parentId, String pluginName, ConfigGroupEnum configGroupEnum, AdminPluginOperateEnum adminPluginOperateEnum) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(ResourceDTO.builder().parentId(parentId).name("").url("").component("").resourceType(AdminResourceEnum.THREE_MENU.getCode()).isLeaf(Boolean.TRUE).status(1).sort(0).icon("").isRoute(0).build());
        switch (configGroupEnum) {
            case SELECTOR: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.SELECTOR.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Selector:" + adminPluginOperateEnum.getName());
                break;
            }
            case RULE: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.RULE.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Rule:" + adminPluginOperateEnum.getName());
                break;
            }
            case PLUGIN: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + ":" + adminPluginOperateEnum.getName());
                break;
            }
        }
        this.insertPluginMenuResource(resourceDO);
    }
}

