/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.JwtProperties;
import org.apache.shenyu.admin.config.properties.LdapProperties;
import org.apache.shenyu.admin.config.properties.SecretProperties;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.mapper.UserRoleMapper;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.dto.UserRoleDTO;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.entity.UserRoleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.DashboardUserQuery;
import org.apache.shenyu.admin.model.vo.DashboardUserEditVO;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.model.vo.LoginDashboardUserVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.utils.AesUtils;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class DashboardUserServiceImpl
implements DashboardUserService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardUserServiceImpl.class);
    private final SecretProperties secretProperties;
    private final DashboardUserMapper dashboardUserMapper;
    private final UserRoleMapper userRoleMapper;
    private final RoleMapper roleMapper;
    private final DataPermissionMapper dataPermissionMapper;
    @Nullable
    private final LdapProperties ldapProperties;
    @Nullable
    private final LdapTemplate ldapTemplate;
    private final JwtProperties jwtProperties;

    public DashboardUserServiceImpl(SecretProperties secretProperties, DashboardUserMapper dashboardUserMapper, UserRoleMapper userRoleMapper, RoleMapper roleMapper, DataPermissionMapper dataPermissionMapper, @Nullable LdapProperties ldapProperties, @Nullable LdapTemplate ldapTemplate, JwtProperties jwtProperties) {
        this.secretProperties = secretProperties;
        this.dashboardUserMapper = dashboardUserMapper;
        this.userRoleMapper = userRoleMapper;
        this.roleMapper = roleMapper;
        this.dataPermissionMapper = dataPermissionMapper;
        this.ldapProperties = ldapProperties;
        this.ldapTemplate = ldapTemplate;
        this.jwtProperties = jwtProperties;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(DashboardUserDTO dashboardUserDTO) {
        DashboardUserDO dashboardUserDO = DashboardUserDO.buildDashboardUserDO(dashboardUserDTO);
        if (StringUtils.isEmpty((CharSequence)dashboardUserDTO.getId())) {
            this.bindUserRole(dashboardUserDO.getId(), dashboardUserDTO.getRoles());
            return this.dashboardUserMapper.insertSelective(dashboardUserDO);
        }
        if (!"admin".equals(dashboardUserDTO.getUserName())) {
            this.userRoleMapper.deleteByUserId(dashboardUserDTO.getId());
        }
        if (CollectionUtils.isNotEmpty(dashboardUserDTO.getRoles())) {
            this.bindUserRole(dashboardUserDTO.getId(), dashboardUserDTO.getRoles());
        }
        return this.dashboardUserMapper.updateSelective(dashboardUserDO);
    }

    @Override
    public int delete(List<String> ids) {
        int dashboardUserCount = 0;
        for (String id : ids) {
            DashboardUserDO dashboardUserDO = this.dashboardUserMapper.selectById(id);
            if (!ObjectUtils.isEmpty((Object)dashboardUserDO) && "admin".equals(dashboardUserDO.getUserName())) continue;
            dashboardUserCount += this.dashboardUserMapper.delete(id);
            this.userRoleMapper.deleteByUserId(id);
            this.dataPermissionMapper.deleteByUserId(id);
        }
        return dashboardUserCount;
    }

    @Override
    public DashboardUserEditVO findById(String id) {
        return DashboardUserEditVO.buildDashboardUserEditVO(DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectById(id)), this.userRoleMapper.findByUserId(id).stream().map(item -> RoleVO.buildRoleVO(this.roleMapper.selectById(item.getRoleId()))).filter(Objects::nonNull).collect(Collectors.toList()), this.roleMapper.selectAll().stream().map(RoleVO::buildRoleVO).collect(Collectors.toList()));
    }

    @Override
    public DashboardUserVO findByQuery(String userName, String password) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.findByQuery(userName, password));
    }

    @Override
    public DashboardUserVO findByUserName(String userName) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectByUserName(userName));
    }

    @Override
    public CommonPager<DashboardUserVO> listByPage(DashboardUserQuery dashboardUserQuery) {
        return PageResultUtils.result(dashboardUserQuery.getPageParameter(), () -> this.dashboardUserMapper.countByQuery(dashboardUserQuery), () -> this.dashboardUserMapper.selectByQuery(dashboardUserQuery).stream().map(DashboardUserVO::buildDashboardUserVO).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LoginDashboardUserVO login(String userName, String password) {
        DashboardUserVO dashboardUserVO = null;
        if (Objects.nonNull(this.ldapTemplate)) {
            dashboardUserVO = this.loginByLdap(userName, password);
        }
        if (Objects.isNull(dashboardUserVO)) {
            dashboardUserVO = this.loginByDatabase(userName, password);
        }
        return LoginDashboardUserVO.buildLoginDashboardUserVO(dashboardUserVO).setToken(JwtUtils.generateToken(dashboardUserVO.getUserName(), dashboardUserVO.getPassword(), this.jwtProperties.getExpiredSeconds()));
    }

    private DashboardUserVO loginByLdap(String userName, String password) {
        String key = this.secretProperties.getKey();
        String iv = this.secretProperties.getIv();
        String searchBase = String.format("%s=%s,%s", this.ldapProperties.getLoginField(), LdapEncoder.nameEncode((String)userName), this.ldapProperties.getBaseDn());
        String filter = String.format("(objectClass=%s)", this.ldapProperties.getObjectClass());
        try {
            DashboardUserVO dashboardUserVO = null;
            if (this.ldapTemplate.authenticate(searchBase, filter, password) && Objects.isNull(dashboardUserVO = this.findByUserName(userName))) {
                RoleDO role = this.roleMapper.findByRoleName("default");
                DashboardUserDTO dashboardUserDTO = DashboardUserDTO.builder().userName(userName).password(AesUtils.aesEncryption(password, key, iv)).role(1).roles(Lists.newArrayList((Object[])new String[]{role.getId()})).enabled(true).build();
                this.createOrUpdate(dashboardUserDTO);
                dashboardUserVO = new DashboardUserVO();
                BeanUtils.copyProperties((Object)dashboardUserDTO, (Object)dashboardUserVO);
            }
            return dashboardUserVO;
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("ldap verify error.", (Throwable)e);
            return null;
        }
    }

    private DashboardUserVO loginByDatabase(String userName, String password) {
        String key = this.secretProperties.getKey();
        String iv = this.secretProperties.getIv();
        DashboardUserVO dashboardUserVO = this.findByQuery(userName, AesUtils.aesEncryption(password, key, iv));
        return dashboardUserVO;
    }

    private void bindUserRole(String userId, List<String> roleIds) {
        roleIds.forEach(item -> this.userRoleMapper.insertSelective(UserRoleDO.buildUserRoleDO(UserRoleDTO.builder().userId(userId).roleId((String)item).build())));
    }
}

