/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.page;

import java.io.Serializable;
import java.util.Objects;

public class PageParameter
implements Serializable {
    private static final long serialVersionUID = -8324693985921606090L;
    private static final int DEFAULT_PAGE_SIZE = 12;
    private int currentPage;
    private int prePage;
    private int nextPage;
    private int pageSize;
    private int offset;
    private int totalPage;
    private int totalCount;

    public PageParameter() {
        this.currentPage = 1;
        this.pageSize = 12;
    }

    public PageParameter(Integer currentPage, Integer pageSize) {
        this.currentPage = currentPage == null || currentPage <= 0 ? 1 : currentPage;
        this.pageSize = pageSize == null || pageSize <= 0 ? 12 : pageSize;
        this.offset = (this.currentPage - 1) * this.pageSize;
    }

    public PageParameter(int currentPage, int pageSize, int totalCount) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.totalPage = (int)Math.ceil((double)totalCount / (double)pageSize);
        this.prePage = currentPage <= 1 ? 1 : currentPage - 1;
        this.nextPage = currentPage >= this.totalPage ? this.totalPage : currentPage + 1;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageParameter)) {
            return false;
        }
        PageParameter that = (PageParameter)o;
        return this.currentPage == that.currentPage && this.prePage == that.prePage && this.nextPage == that.nextPage && this.pageSize == that.pageSize && this.offset == that.offset && this.totalPage == that.totalPage && this.totalCount == that.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.currentPage, this.prePage, this.nextPage, this.pageSize, this.offset, this.totalPage, this.totalCount);
    }

    public String toString() {
        return "PageParameter{currentPage=" + this.currentPage + ", prePage=" + this.prePage + ", nextPage=" + this.nextPage + ", pageSize=" + this.pageSize + ", offset=" + this.offset + ", totalPage=" + this.totalPage + ", totalCount=" + this.totalCount + '}';
    }
}

