/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.http;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.config.properties.HttpSyncProperties;
import org.apache.shenyu.admin.listener.AbstractDataChangedListener;
import org.apache.shenyu.admin.listener.ConfigDataCache;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.constant.HttpConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLongPollingDataChangedListener
extends AbstractDataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLongPollingDataChangedListener.class);
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_FOR_SPLIT_SYMBOL = ",";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final BlockingQueue<LongPollingClient> clients = new ArrayBlockingQueue<LongPollingClient>(1024);
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"long-polling", (boolean)true));
    private final HttpSyncProperties httpSyncProperties;

    public HttpLongPollingDataChangedListener(HttpSyncProperties httpSyncProperties) {
        this.httpSyncProperties = httpSyncProperties;
    }

    @Override
    protected void afterInitialize() {
        long syncInterval = this.httpSyncProperties.getRefreshInterval().toMillis();
        this.scheduler.scheduleWithFixedDelay(() -> {
            LOG.info("http sync strategy refresh config start.");
            try {
                this.refreshLocalCache();
                LOG.info("http sync strategy refresh config success.");
            }
            catch (Exception e) {
                LOG.error("http sync strategy refresh config error!", (Throwable)e);
            }
        }, syncInterval, syncInterval, TimeUnit.MILLISECONDS);
        LOG.info("http sync strategy refresh interval: {}ms", (Object)syncInterval);
    }

    private void refreshLocalCache() {
        this.updateAppAuthCache();
        this.updatePluginCache();
        this.updateRuleCache();
        this.updateSelectorCache();
        this.updateMetaDataCache();
    }

    public void doLongPolling(HttpServletRequest request, HttpServletResponse response) {
        List<ConfigGroupEnum> changedGroup = this.compareChangedGroup(request);
        String clientIp = HttpLongPollingDataChangedListener.getRemoteIp(request);
        if (CollectionUtils.isNotEmpty(changedGroup)) {
            this.generateResponse(response, changedGroup);
            LOG.info("send response with the changed group, ip={}, group={}", (Object)clientIp, changedGroup);
            return;
        }
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        this.scheduler.execute(new LongPollingClient(asyncContext, clientIp, HttpConstants.SERVER_MAX_HOLD_TIMEOUT));
    }

    @Override
    protected void afterAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        this.scheduler.execute(new DataChangeTask(ConfigGroupEnum.APP_AUTH));
    }

    @Override
    protected void afterMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        this.scheduler.execute(new DataChangeTask(ConfigGroupEnum.META_DATA));
    }

    @Override
    protected void afterPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        this.scheduler.execute(new DataChangeTask(ConfigGroupEnum.PLUGIN));
    }

    @Override
    protected void afterRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        this.scheduler.execute(new DataChangeTask(ConfigGroupEnum.RULE));
    }

    @Override
    protected void afterSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        this.scheduler.execute(new DataChangeTask(ConfigGroupEnum.SELECTOR));
    }

    private List<ConfigGroupEnum> compareChangedGroup(HttpServletRequest request) {
        ArrayList<ConfigGroupEnum> changedGroup = new ArrayList<ConfigGroupEnum>(ConfigGroupEnum.values().length);
        for (ConfigGroupEnum group : ConfigGroupEnum.values()) {
            String[] params = StringUtils.split((String)request.getParameter(group.name()), (char)',');
            if (params == null || params.length != 2) {
                throw new ShenyuException("group param invalid:" + request.getParameter(group.name()));
            }
            String clientMd5 = params[0];
            long clientModifyTime = NumberUtils.toLong((String)params[1]);
            ConfigDataCache serverCache = (ConfigDataCache)CACHE.get(group.name());
            if (!this.checkCacheDelayAndUpdate(serverCache, clientMd5, clientModifyTime)) continue;
            changedGroup.add(group);
        }
        return changedGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCacheDelayAndUpdate(ConfigDataCache serverCache, String clientMd5, long clientModifyTime) {
        if (StringUtils.equals((CharSequence)clientMd5, (CharSequence)serverCache.getMd5())) {
            return false;
        }
        long lastModifyTime = serverCache.getLastModifyTime();
        if (lastModifyTime >= clientModifyTime) {
            return true;
        }
        boolean locked = false;
        try {
            locked = LOCK.tryLock(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        if (locked) {
            try {
                ConfigDataCache latest = (ConfigDataCache)CACHE.get(serverCache.getGroup());
                if (latest != serverCache) {
                    boolean bl = !StringUtils.equals((CharSequence)clientMd5, (CharSequence)latest.getMd5());
                    return bl;
                }
                this.refreshLocalCache();
                latest = (ConfigDataCache)CACHE.get(serverCache.getGroup());
                boolean bl = !StringUtils.equals((CharSequence)clientMd5, (CharSequence)latest.getMd5());
                return bl;
            }
            finally {
                LOCK.unlock();
            }
        }
        return true;
    }

    private void generateResponse(HttpServletResponse response, List<ConfigGroupEnum> changedGroups) {
        try {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-cache,no-store");
            response.setContentType("application/json");
            response.setStatus(200);
            response.getWriter().println(GsonUtils.getInstance().toJson((Object)ShenyuAdminResult.success("success", changedGroups)));
        }
        catch (IOException ex) {
            LOG.error("Sending response failed.", (Throwable)ex);
        }
    }

    private static String getRemoteIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR);
        if (!StringUtils.isBlank((CharSequence)xForwardedFor)) {
            return xForwardedFor.split(X_FORWARDED_FOR_SPLIT_SYMBOL)[0].trim();
        }
        String header = request.getHeader(X_REAL_IP);
        return StringUtils.isBlank((CharSequence)header) ? request.getRemoteAddr() : header;
    }

    class LongPollingClient
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(LongPollingClient.class);
        private final AsyncContext asyncContext;
        private final String ip;
        private final long timeoutTime;
        private Future<?> asyncTimeoutFuture;

        LongPollingClient(AsyncContext ac, String ip, long timeoutTime) {
            this.asyncContext = ac;
            this.ip = ip;
            this.timeoutTime = timeoutTime;
        }

        @Override
        public void run() {
            try {
                this.asyncTimeoutFuture = HttpLongPollingDataChangedListener.this.scheduler.schedule(() -> {
                    HttpLongPollingDataChangedListener.this.clients.remove(this);
                    List changedGroups = HttpLongPollingDataChangedListener.this.compareChangedGroup((HttpServletRequest)this.asyncContext.getRequest());
                    this.sendResponse(changedGroups);
                }, this.timeoutTime, TimeUnit.MILLISECONDS);
                HttpLongPollingDataChangedListener.this.clients.add(this);
            }
            catch (Exception ex) {
                this.log.error("add long polling client error", (Throwable)ex);
            }
        }

        void sendResponse(List<ConfigGroupEnum> changedGroups) {
            if (null != this.asyncTimeoutFuture) {
                this.asyncTimeoutFuture.cancel(false);
            }
            HttpLongPollingDataChangedListener.this.generateResponse((HttpServletResponse)this.asyncContext.getResponse(), changedGroups);
            this.asyncContext.complete();
        }
    }

    class DataChangeTask
    implements Runnable {
        private final ConfigGroupEnum groupKey;
        private final long changeTime = System.currentTimeMillis();

        DataChangeTask(ConfigGroupEnum groupKey) {
            this.groupKey = groupKey;
        }

        @Override
        public void run() {
            if (HttpLongPollingDataChangedListener.this.clients.size() > HttpLongPollingDataChangedListener.this.httpSyncProperties.getNotifyBatchSize()) {
                ArrayList targetClients = new ArrayList(HttpLongPollingDataChangedListener.this.clients.size());
                HttpLongPollingDataChangedListener.this.clients.drainTo(targetClients);
                List partitionClients = Lists.partition(targetClients, (int)HttpLongPollingDataChangedListener.this.httpSyncProperties.getNotifyBatchSize());
                partitionClients.forEach(item -> HttpLongPollingDataChangedListener.this.scheduler.execute(() -> this.doRun((Collection<LongPollingClient>)item)));
            } else {
                this.doRun(HttpLongPollingDataChangedListener.this.clients);
            }
        }

        private void doRun(Collection<LongPollingClient> clients) {
            Iterator<LongPollingClient> iter = clients.iterator();
            while (iter.hasNext()) {
                LongPollingClient client = iter.next();
                iter.remove();
                client.sendResponse(Collections.singletonList(this.groupKey));
                LOG.info("send response with the changed group,ip={}, group={}, changeTime={}", new Object[]{client.ip, this.groupKey, this.changeTime});
            }
        }
    }
}

