/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.etcd;

import org.apache.shenyu.admin.listener.etcd.EtcdClient;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class EtcdDataInit
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdDataInit.class);
    private final EtcdClient etcdClient;
    private final SyncDataService syncDataService;

    public EtcdDataInit(EtcdClient client, SyncDataService syncDataService) {
        this.etcdClient = client;
        this.syncDataService = syncDataService;
    }

    public void run(String ... args) throws Exception {
        String pluginPath = "/shenyu/plugin";
        String authPath = "/shenyu/auth";
        String metaDataPath = "/shenyu/metaData";
        if (!(this.etcdClient.exists("/shenyu/plugin").booleanValue() || this.etcdClient.exists("/shenyu/auth").booleanValue() || this.etcdClient.exists("/shenyu/metaData").booleanValue())) {
            LOG.info("Init all data from database");
            this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        }
    }
}

