/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.consul;

import com.ecwid.consul.v1.ConsulClient;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.boot.CommandLineRunner;

public class ConsulDataInit
implements CommandLineRunner {
    private final ConsulClient consulClient;
    private final SyncDataService syncDataService;

    public ConsulDataInit(ConsulClient consulClient, SyncDataService syncDataService) {
        this.consulClient = consulClient;
        this.syncDataService = syncDataService;
    }

    public void run(String ... args) {
        String pluginData = "shenyu/sync/plugin";
        String authData = "shenyu/sync/auth";
        String metaData = "shenyu/sync/meta";
        if (this.dataKeyNotExist(pluginData) && this.dataKeyNotExist(authData) && this.dataKeyNotExist(metaData)) {
            this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        }
    }

    private boolean dataKeyNotExist(String dataKey) {
        return this.consulClient.getKVValue(dataKey).getValue() == null;
    }
}

