/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.subscriber;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;

public class URIRegisterExecutorSubscriber
implements ExecutorTypeSubscriber<URIRegisterDTO> {
    private final Map<String, ShenyuClientRegisterService> shenyuClientRegisterService;

    public URIRegisterExecutorSubscriber(Map<String, ShenyuClientRegisterService> shenyuClientRegisterService) {
        this.shenyuClientRegisterService = shenyuClientRegisterService;
    }

    public DataType getType() {
        return DataType.URI;
    }

    public void executor(Collection<URIRegisterDTO> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        this.findService(dataList).ifPresent(service -> {
            Map<String, List<URIRegisterDTO>> listMap = this.buildData(dataList);
            listMap.forEach(service::registerURI);
        });
    }

    private Map<String, List<URIRegisterDTO>> buildData(Collection<URIRegisterDTO> dataList) {
        HashMap<String, List<URIRegisterDTO>> resultMap = new HashMap<String, List<URIRegisterDTO>>();
        for (URIRegisterDTO dto : dataList) {
            String contextPath = dto.getContextPath();
            String key = StringUtils.isNotEmpty((CharSequence)contextPath) ? contextPath : dto.getAppName();
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            if (resultMap.containsKey(key)) {
                List existList = (List)resultMap.get(key);
                existList.add(dto);
                resultMap.put(key, existList);
                continue;
            }
            resultMap.put(key, Lists.newArrayList((Object[])new URIRegisterDTO[]{dto}));
        }
        return resultMap;
    }

    private Optional<ShenyuClientRegisterService> findService(Collection<URIRegisterDTO> dataList) {
        return dataList.stream().map(dto -> this.shenyuClientRegisterService.get(dto.getRpcType())).findFirst();
    }
}

