/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.executor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.disruptor.consumer.QueueConsumerExecutor;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.subsriber.AbstractQueueConsumerFactory;
import org.apache.shenyu.register.common.subsriber.ExecutorSubscriber;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;
import org.apache.shenyu.register.common.type.DataTypeParent;

public final class RegisterServerConsumerExecutor
extends QueueConsumerExecutor<List<DataTypeParent>> {
    private Map<DataType, ExecutorSubscriber> subscribers = new HashMap<DataType, ExecutorSubscriber>();

    private RegisterServerConsumerExecutor(Map<DataType, ExecutorTypeSubscriber> executorSubscriberMap) {
        this.subscribers.putAll(executorSubscriberMap);
    }

    public void run() {
        List<DataTypeParent> results = (List<DataTypeParent>)this.getData();
        if (CollectionUtils.isEmpty(results = results.stream().filter(data -> this.isValidData(data)).collect(Collectors.toList()))) {
            return;
        }
        this.getType(results).executor(results);
    }

    private boolean isValidData(Object data) {
        if (data instanceof URIRegisterDTO) {
            URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)data;
            return Objects.nonNull(uriRegisterDTO.getPort()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uriRegisterDTO.getAppName(), uriRegisterDTO.getHost()});
        }
        if (data instanceof MetaDataRegisterDTO) {
            MetaDataRegisterDTO metaDataRegisterDTO = (MetaDataRegisterDTO)data;
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaDataRegisterDTO.getAppName(), metaDataRegisterDTO.getPath(), metaDataRegisterDTO.getRuleName(), metaDataRegisterDTO.getRpcType()});
        }
        return true;
    }

    private ExecutorSubscriber getType(List<DataTypeParent> list) {
        DataTypeParent result = list.get(0);
        return this.subscribers.get(result.getType());
    }

    public static class RegisterServerExecutorFactory
    extends AbstractQueueConsumerFactory {
        public QueueConsumerExecutor create() {
            Map<DataType, ExecutorTypeSubscriber> maps = this.getSubscribers().stream().map(e -> (ExecutorTypeSubscriber)e).collect(Collectors.toMap(ExecutorTypeSubscriber::getType, e -> e));
            return new RegisterServerConsumerExecutor(maps);
        }

        public String fixName() {
            return "shenyu_register_server";
        }
    }
}

