/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Collections;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.spi.Join;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/shenyu-client"})
@Join
public class ShenyuHttpRegistryController
implements ShenyuServerRegisterRepository {
    private ShenyuServerRegisterPublisher publisher;

    public void init(ShenyuServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
    }

    @PostMapping(value={"/register-metadata"})
    @ResponseBody
    public String registerMetadata(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-uri"})
    @ResponseBody
    public String registerURI(@RequestBody URIRegisterDTO uriRegisterDTO) {
        this.publish(uriRegisterDTO);
        return "success";
    }

    private <T> void publish(T t) {
        this.publisher.publish(Collections.singletonList(t));
    }
}

